/*! \file np_trapping.cpp
 *
 * \brief Trapping problem handler.
 */
#include <chrono>
#include <cstdio>
#include <string>

#ifndef INCLUDE_LOGGING_H_
#include "../include/logging.h"
#endif

using namespace std;

extern void frfme(string data_file, string output_path);
extern void lffft(string data_file, string output_path);

/*! \brief Main program execution body.
 *
 * \param argc: `int`
 * \param argv: `char **`
 * \return result: `int`
 */
int main(int argc, char **argv) {
  chrono::time_point<chrono::high_resolution_clock> t_start = chrono::high_resolution_clock::now();
  chrono::duration<double> elapsed;
  string frfme_data_file = "../../test_data/trapping/DFRFME";
  string lffft_data_file = "../../test_data/trapping/DLFFFT";
  string output_path = ".";
  string message;
  Logger logger(LOG_DEBG);
  if (argc == 4) {
    frfme_data_file = string(argv[1]);
    lffft_data_file = string(argv[2]);
    output_path = string(argv[3]);
  }
  frfme(frfme_data_file, output_path);
  lffft(lffft_data_file, output_path);
  elapsed = chrono::high_resolution_clock::now() - t_start;
  message = "INFO: calculation lasted " + to_string(elapsed.count()) + "s.\n";
  logger.log(message);
  return 0;
}
