# Folder instructions

This directory collects the input files to test the code.

## Instructions

The execution of the original code can be controlled through a set of configuration files that define the characteristics of the problem and affect the type of output. The following sections describe the contents of the configuration files and, to some extent, those of the output ones, presenting one code in each section.

### cluster

`clu` is designed to calculate a complex geometry made up by many spheres. These can be either fully embedded in a larger sphere or separated within the external medium. Sphere compenetration is not accounted for.

*TODO:* add the description of the cluster configuration files

### sphere

`sph` is designed to perform the simplest case calculation, namely the scattering of incident radiation on a single sphere. To perform the calculation, the two following formatted files need to be provided:

- DEDFB
```
   SPHERE_NUMBER   EXTERNAL_SPHERE_FLAG
   EXT_DIEL_CONST   PEAK_WAVE   PEAK_SCALE   DIEL_TYPE   SCALE_NUMBER   SCALE_STEP_FLAG   CONTROL_VARIABLE
   SCALE_VECTOR   [SCALE_VECTOR_STEP]
        |
	v
   SPHERE_ID_VECTOR ->
   LAYER_NUMBER_VECTOR   SPHERE_RADII_VECTOR
            |                     |
	    v                     v
   FRACTIONAL_BREAK_RADII ->
             |
	     v
   DIEL_CONST_VECTOR ->
          |
	  v
   EOF_CODE
```
were the different lines have the following roles:
1. declare the number of spheres and whether to add an external layer
2. define the external dielectric constant and the scaling configuration
3. define the vector of scales (either explicitly, with one element per row, or in steps, with only first element and step declared)
4. create a vector of IDs to attach to the spheres
5. define the vectors spcifying the number of layers and the radii of the spheres (one sphere per line)
6. define the fractional break radii (one line per sphere, one column per layer)
7. define the vector of dielectric constants or starting functions (one line per sphere, one column per layer)
8. an end-of-file code (generally 0)

- DSPH
```
  SPHERE_NUMBER  MAXIMUM_L_ORDER  POLARIZATION_STATUS  TRANSITION_SHARPNESS_1  TRANSITION_SHARPNESS_2  GEOMETRY
  STARTING_INC_THETA  INC_THETA_STEP  FINAL_INC_THETA  STARTING_SCA_THETA  SCA_THETA_STEP  FINAL_SCA_THETA
  STARTING_INC_PHI  INC_PHI_STEP  FINAL_INC_PHI  STARTING_SCA_PHI  SCA_PHI_STEP  FINAL_SCA_PHI
  WRITE_INTERMEDIATE_FILE
EOF_CODE
```
were the different lines have the following roles:
1. general configuration of the scattering problem, with some specification of the transition between materials
2. definition of the elevation angle arrays for the incident and scattered radiation fields
3. definition of the azimuth angle arrays for the incident and scattered radiation fields
4. a flag to set whether the intermediate data should be written to output files
5. an end-of-file code (generally 0)

# License

   Copyright 2004 INAF - Osservatorio Astronomico di Cagliari

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
