#!/bin/bash
set -vex

REPOS=(gitlab-profile core io integrate octree domain PM)
SESSION_NAME=how

while getopts "csapt" opt
do
   case "$opt" in
      c ) clona=1 ;;
      s ) tmuxa=1 ;;
      a ) attaccha=1 ;;
      p ) installa=1 ;;
      t ) testa=1 ;;
   esac
done

if [ -z "$clona" ] && [ -z "$tmuxa" ] && [ -z "$attaccha" ];then
    echo 'usage: ./cloneall.bash -c (clone repos) -p (pip install) -t (python tests) -s (create screen tmux session) -a (attach to tmux)'
    exit 1
fi

if [ ! -z "$clona" ]; then
    [[ ! -d "venv" ]] && python3 -mvenv venv
    . venv/bin/activate
    pip install autopep8
    pip install matplotlib
    touch .env
    
    for REPO in "${REPOS[@]}"; do

	[[ ! -d "$REPO" ]] && git clone ssh://git@git.ia2.inaf.it/hotwheels/$REPO.git
        pushd $REPO
        git switch dev || echo no dev branch
	if [[ "$REPO" != "gitlab-profile" ]]; then
	    [ ! -z "$installa" ] && python -mpip install -e .
	    [ ! -z "$testa" ] && python -m hotwheels.checkup hotwheels/
	fi
        popd
    done
fi

if [ ! -z "$tmuxa" ]; then
    
    if ! tmux has-session -t $SESSION_NAME ; then
	# Create a new tmux session
	tmux new-session -d -s $SESSION_NAME -c $PWD
	
	for index in "${!REPOS[@]}"; do
            value="${REPOS[index]}"
	    
            # Initialize the environment in the first window
            tmux send-keys -t $SESSION_NAME:$index ". .env" C-m
            tmux send-keys -t $SESSION_NAME:$index ". venv/bin/activate" C-m
            tmux send-keys -t $SESSION_NAME:$index "cd $PWD/$value" C-m
            tmux new-window -t $SESSION_NAME -c $PWD
	done
    fi
fi

if [ ! -z "$attaccha" ]; then
    tmux attach-session -t $SESSION_NAME
fi

echo done
