**TOC:**

[TOC]

# Install the non-developer (easy) way

For the user that is not going to edit the code and is only interested in running simulations, the process is very easy.

For instance, to perform a simulation with particle mesh one can execute:

```bash
::include{file=test_install_octree.bash}
```

This will install also the following hotwheels packages: core, io, timestep. 
The `[tested]` tag will install the versions of the dependencies used to test the release (`v0.0.0alpha` in this case).

# Run tests

To run the C and python tests of the installed `hotwheels` components, run: 

```bash
::include{file=test_checkup.bash}
```

Here below some relevant environment variables to change hotwheels default settings:

| Environment Variable | Description                                                                                           |
|----------------------|-------------------------------------------------------------------------------------------------------|
| `CC`                | C compiler (defaults to `gcc`).                                                                      |
| `MPICC`             | MPI C compiler (defaults to `mpicc`).                                                                |
| `CXX`               | C++ compiler (defaults to `g++`).                                                                    |
| `MPICXX`            | MPI C++ compiler (defaults to `mpicxx`).                                                             |
| `HW_FLAGS`          | Compilation specific flags (i.e. not used by clang for parsing).                                    |
| `HW_BUILD`          | Folder with runtime-generated headers, and C/C++ compiled object files.                              |
| `DEBUG`             | Set to `1` to enable additional verbose output for debugging purposes.                               |
| `C_INCLUDE_PATH`    | *(used by the gnu compiler)* Search path for C headers, should include paths for required libraries like `gsl` and `fftw3`.       |
| `CPLUS_INCLUDE_PATH`|  *(used by the gnu compiler)* Search path for C++ headers, should include paths for required libraries like `gsl` and `fftw3`.     |
| `LD_LIBRARY_PATH`   | *(used by linux)*  Search path for runtime libraries, should include paths for required libraries like `gsl` and `fftw3`.|


# Install the developer way

## Install custom versions

In case you want to run the module with other `hotwheel` component version you can install each manually:

```bash
::include{file=test_pip_all.bash}
```

## If you need to put hands on the source code

In case you find that you need to edit the source code of hotwheels (maybe you found a bug), you
can re-install a python module in **editable mode (use -e in pip install)**. For instance, let's suppose that now you need to edit the timestep module and re-run all tests. You can do the following 

```bash
::include{file=test_editable.bash}
```

## Bulk install of all modules

In case you need to work on many modules, you can clone and install all default packages with the [cloneall.bash](cloneall.bash) script:

```bash
::include{file=test_bulk.bash}
```

If you want to create a folder with all the modules soft-linked into the folder `hotwheels/*`, add the flag `-l` to `cloneall.bash` to get this folder tree in a folder named `full/hotwheels/*`.
This is helpful in navigating the files with the IDE when development has strong refactoring and one need to edit multiple modules.

If you want to also create a multi-windows tmux session where each panel corresponds to a hotwheels module add the flag `-t` to `cloneall.bash` (will laso include the folder `full` if exists).

You can insert a personalised number of repos by running for instance `cloneall.bash [..] -r core octree` (will only download core and octree module).

