The components of `hotwheels` are stored in git repos. Each component has a python wrapper and both the python and C library can be installed using `pip`.
Note that, as opposed to the typical `pip install`, the C compilation **will not** happen on `pip install`. The components will keep the source codes and they will be compiled on runtime. This has the benefit of allowing recompilation with different modules (as C and mpicc compilers), typical on HPC facilities. 

# The non-developer (easy) way

For the user that is not going to edit the code and is only interested in running simulations, the process is very easy.

For instance, to perform a simulation with particle mesh one can execute:

```bash
pip install 'hotwheels_PM[tested] @ git+ssh://git@git.ia2.inaf.it/hotwheels/PM.git@v0.0.0alpha'
```

This will install also the following hotwheels packages: core, io, timestep. 
The `[tested]` tag will install the versions of the dependencies used to test the release (`v0.0.0alpha` in this case).


# Install custom release versions

In case you want to run the module with other `hotwheel` component version you can install each manually:

```bash
pip install git+ssh://git@git.ia2.inaf.it/hotwheels/core.git@v0.0.0alpha
pip install git+ssh://git@git.ia2.inaf.it/hotwheels/io.git@v0.0.0alpha
pip install git+ssh://git@git.ia2.inaf.it/hotwheels/timestep.git@v0.0.0alpha
pip install git+ssh://git@git.ia2.inaf.it/hotwheels/PM.git@v0.0.0alpha
```

# If you need to put hands on the source code

In case you find that you need to edit the source code of hotwheels (maybe you found a bug), you
can re-install a python module in **editable mode (use -e in pip install)**. For instance, let's suppose that now you need to edit the timestep module and re-run all tests. You can do the following 

```bash
git clone ssh://git@git.ia2.inaf.it/hotwheels/timestep.git
cd timestep
# very IMPORTANT the -e will install in editable mode
# so you can change the module code and effects will take place
# without need of uninstall and re-install
pip install -e . 
# edit the file of your chise, for instance ./hotwheels/timestep/cosmo.c 
cd ..
python -m hotwheels.checkup hotwheels #now the tests are run with the new ./hotwheels/timestep/cosmo.c 
```

# Run tests

To run the C and python tests of the installed `hotwheels` components, run: 

```bash
python -m hotwheels.checkup hotwheels
```

The tests will be run using envirnoment varialbe `CC` for the C ompiler (will default to `gcc`), `MPICC` for the MPI compiler (will default to `mpicc`),   `CXX` and `MPICXX` for the c++ version (will default to `g++` and `mpicxx` respectively). 

The PM run needs the `gsl` and `fftw3` to be installed. They should be either in a standard path (`/usr/{lib,include}`) or in your compiler search path (namely, in your `C_INCLUDE_PATH`, `CPLUS_INCLUDE_PATH`, and `LD_LIBRARY_PATH` env variables).

