#pragma once

#include "energy_pmt_methods.h"

#if defined(_ENERGY_RAPL_) || defined(_ENERGY_NVIDIA_) || defined(_ENERGY_AMD_)
   #define PMT_CREATE(numGPUs) Create_PMT((numGPUs))
#else
   #define PMT_CREATE(numGPUs)
#endif // defined(_ENERGY_RAPL_) || defined(_ENERGY_NVIDIA_) || defined(_ENERGY_AMD_)

#if defined(_ENERGY_RAPL_)
   #define PMT_CPU_START(string) Start_PMT_CPU((string))
   #define PMT_CPU_STOP(string)  Stop_PMT_CPU((string))
   #define PMT_CPU_SHOW(string)  Show_PMT_CPU((string))
#else
   #define PMT_CPU_START(string)
   #define PMT_CPU_STOP(string)
   #define PMT_CPU_SHOW(string)
#endif // _ENERGY_RAPL_

#if defined(_ENERGY_NVIDIA_) || defined(_ENERGY_AMD_)
   #define PMT_GPU_START(string) Start_PMT_GPU((string))
   #define PMT_GPU_STOP(string)  Stop_PMT_GPU((string))
   #define PMT_GPU_SHOW(string)  Show_PMT_GPU((string))
#else
   #define PMT_GPU_START(string)
   #define PMT_GPU_STOP(string)
   #define PMT_GPU_SHOW(string)
#endif // defined(_ENERGY_NVIDIA_) || defined(_ENERGY_AMD_)

