#!/bin/bash

######################### RESOURSE ALLOCATION #####################################
#SBATCH --account=hpc_school
#SBATCH --partition=hpc_school
#SBATCH --job-name="Jacobi"
#SBATCH --nodes=1
#SBATCH --cpus-per-task=1
#SBATCH --output=Jacobi-serial-no-opt-%j.out
#SBATCH --error=Jacobi-serial-no-opt.%j.err
#SBATCH --time=00:05:00
###################################################################################

################################## MODULES ########################################
export MODULE_VERSION=5.0.1
source /opt/cluster/spack/share/spack/setup-env.sh

# module purge
module purge
# load GCC
module load default-gcc-11.2.0
# load valgrind (optional)
module load valgrind-3.18.1-gcc-11.2.0-3hcfkwk
###################################################################################

# input parameters
source input_parameters

WORKDIR=${PWD}
# compile the application
cd .. && make clean && make serial
if [[ "$?" != "0" ]]
then
    echo "Cannot compile the application ...aborting..."
    exit 1
fi

# get the executable
EXEC=$(find $(realpath ./) -maxdepth 1 -executable -name "jacobi_*" -type f -print)
if [[ "$?" != "0" ]]
then
    echo "Cannot find the executable ...aborting..."
    exit 2
fi


# run 
time ${EXEC} ${GRID_SIZE_X} ${GRID_SIZE_Y} |& tee ${EXEC}_output.txt

cd ${WORKDIR}

exit 0
