//////////////////////////////////////////////////////////////////////////////////////////////////
// Assigment : write a CUDA code corresponding to the
// following sequential C code
//
// #include <stdio.h>
// #define N 100
// int main()
// {
//   for (int i=0 ; i<N ; i++)
//     printf("%d\n", (i * i));

//   return 0;
// }
//////////////////////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////////////////////
// Author: David Goz
// mail  : david.goz@inaf.it
// date  : 06.07.2024
//
// - Compile the code:
//   $ nvcc classwork_1.cu -o classwork_1_cuda
// - Run the code:
//   $ ./classwork_1_cuda
// - Check the result:
//   $ ./classwork_1_cuda | tail -n 100 | sort -nk 5

//////////////////////////////////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include <cuda.h>

#define N        100
#define NThreads 1024

__global__ void GPUkernel(const int size)
{
  const int myID = threadIdx.x + (blockIdx.x * blockDim.x);
  
  if (myID >= size)
    return;

  // C printf is supported on CUDA
  // C++ cout class is not supported in CUDA
  printf("Hello from CUDA thread: %d - result %d\n", myID, (myID * myID));

  return;
}

int main()
{
  printf("\n\t The host issues the kernel on the GPU \n");
  
  // kernel lunch
  GPUkernel<<<1, NThreads>>>(N);

  printf("\n\t cudaDeviceSynchronize \n");
  // GPU synchronization
  cudaDeviceSynchronize();

  return 0;
}
