//////////////////////////////////////////////////////////////////////////////////////////////////
// Assigment : write a CUDA code corresponding to the
// following sequential C code
//
// #include <stdio.h>
// #define N 100
// int main()
// {
//   int A[N];
//
//   for (int i=0 ; i<N ; i++)
//     A[i] = (i * i);
//
//   return 0;
// }
//////////////////////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////////////////////
// Author: David Goz
// mail  : david.goz@inaf.it
// date  : 17.11.2022
//
// - Compile the code:
//   $ nvcc classwork_2.cu -o classwork_2
// - Run the code:
//   $ ./classwork_2
// - Check the result:
//   $ ./classwork_2 | tail -n 100 | sort -nk 5

//////////////////////////////////////////////////////////////////////////////////////////////////

#include <iostream>
#include <stdlib.h>
#include <cuda.h>

#define N        100
#define NThreads 1024

__global__ void GPUkernel(      int *A,
			  const int size)
{
  const int myID = threadIdx.x + (blockIdx.x * blockDim.x);
  
  if (myID < size)
    A[myID] = (myID * myID);

  return;
}

int main()
{
  // allocate array that allows direct access of both host and device
  //  CUDA is responsible 
  int *A;
  const size_t size = (N * sizeof(int));
  cudaError error = cudaMallocManaged(&A, size);
  if (!error)
    std::cout << "Memory allocated for the host/device" << std::endl;
  else
    {
      std::cout << "Cannot allocate memory for the host/device. CUDA error : " << error << " ... aborting" << std::endl;
      exit(EXIT_FAILURE);
    }
  
  // kernel lunch
  GPUkernel<<<1, NThreads>>>(A, N);
  
  // device synchronization
  cudaDeviceSynchronize();
  
  // check the result
  for (size_t i=0 ; i<N ; i++)
    std::cout << "A[" << i << "] - Result: " << A[i] << std::endl;

  // free the memory
  cudaFree(A);
  
  return 0;
}
