//////////////////////////////////////////////////////////////////////////////////////////////////
//
// OpenMP GPU Offload is available only on systems with NVIDIA GPUs with compute capability '>= cc70'
//
// Assigment : write a OMP-GPU code corresponding to the
// following sequential C code
//
// #include <stdio.h>
// #define N 100
// int main()
// {
//   for (int i=0 ; i<N ; i++)
//     printf("%d\n", (i * i));

//   return 0;
// }
//////////////////////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////////////////////
// Author: David Goz
// mail  : david.goz@inaf.it
// date  : 06.07.2024
//
// - Compile the code to run on :
//   $ nvcc classwork_1.c -o classwork_1_omp
// - Run the code:
//   $ ./classwork_1_omp
// - Check the result:
//   $ ./classwork_1_omp | tail -n 100 | sort -nk 5

//////////////////////////////////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include <omp.h>

#define N        100
#define NThreads 1024

void GPUkernelSerial(const int size)
{
#pragma omp target
  {
    if (!omp_is_initial_device())
      printf("\n\t GPU is executing GPUkernelSerial\n" );
    else
      printf("\n\t CPU is executing GPUkernelSerial\n" );
    
    for (int i=0 ; i<size ; i++)
      printf("Hello from OMP-GPU thread: %d - result %d\n", i, (i * i));
  }
  return;
}

int main()
{
  printf("\n\t The host issues the kernel on the GPU \n");
  
  /* kernel lunch using one GPU thread */
  GPUkernelSerial(N);

  return 0;
}
