#!/bin/bash -x

######################### RESOURSE ALLOCATION #####################################
# ACCOUNT         = prpb93
# NODES           = 2                (2 nodes)
# PARTITION       = batch            (use Cluster Module)
# ERROR           = Nbody-err.%j     (error handle)
# TIME            = 00:15:00         (enough for tests)
# EXCLUSIVE       = node should not be shared with other jobs

#SBATCH --account=prpb93
#SBATCH --nodes=1
#SBATCH --partition=batch
#SBATCH --error=Nbody-err.%j
#SBATCH --time=00:03:00
#SBATCH --job-name="Nbody"
#SBATCH --exclusive
###################################################################################

################################## MODULES ########################################
# module purge
module purge
# load GCC
module load GCC/9.3.0
# load OpenMPI
module load OpenMPI
###################################################################################

# compile the application
# select flags inside the Makefile (parent directory)
cd .. && make mpi_omp_step_profiling -f Makefile

if [[ "$?" != "0" ]]
then
    echo "Cannot compile the application ...aborting..."
    exit 1
fi

# the executable
EXEC=$(find . -name *$(hostname)* -executable -type f)
if [[ "$?" != "0" ]]
then
    echo "Cannot find the executable ...aborting..."
    exit 2
fi

# return to ./script and source input parameters and function
cd - && source input_parameters && source write_paramfile.sh

# loop over particles
for PART in "${N[@]}"
do
    # loop over MPI tasks
    for TASK in "${MPI[@]}"
    do
	# loop over OMP threads
	for THR in "${THREADS[@]}"
	do
	    # write the paramfile
	    write_paramfile ${TEMPLATE}      ${PARAMFILE}       \
			    ${DELETE_OUTPUT_FILES} ${OUTPUTDIR} \
			    ${THR} ${PART}

	    # check the status
	    if [[ "$?" != "0" ]]
	    then
		echo "Error while writing ${PARAMFILE} ...aborting..."
		exit 3
	    fi

	    # move the paramfile and move to the parent directory where the executable resides
	    mv ${PARAMFILE} ../ && cd ..
	    
	    # run the application
	    srun --ntasks ${TASK} ${EXEC} ${PARAMFILE} >& $SLURM_JOB_ID.log

	    # check exit status
	    if [[ "$?" != "0" ]]
	    then
		echo "####################################################################"
		echo "ERROR while running the app using: ${TASK} MPI tasks and ${GPU} GPUs"
		echo "####################################################################"
	    fi

	    # delete the paramfile and return to the previous directory
	    rm -f ${PARAMFILE} && cd -
	done # loop over THR
    done # loop over TASKS
done # looop over particles

# make clean
cd .. && make clean

# Everything is OK!
exit 0
