#!/bin/bash

# NAME: write_paramfile
# PURPOSE: to write a user defined paramfile for the X NBody app
# USAGE: write_paramfile [template_file] [paramfile_to_write]      \
#                        [DeleteOutputFiles] [OutputDir]           \
#                        [OMP threads] [N]

function write_paramfile()
{
    local TEMPLATE=$1

    # check if TEMPLATE is a regular file
    if [ ! -f ${TEMPLATE} ]
    then
	echo "${TEMPLATE} is not a regular file.. aborting..."
	return 1
    fi

    # copy template file
    local PARAMFILE=$2
    cp -v ${TEMPLATE} ${PARAMFILE}

    local DELETE_OUTPUT_FILES=$3
    local OUTPUTDIR=$4
    local THREADS=$5
    local N=$6
    
    # add parameters
    echo "DeleteOutputFiles ${DELETE_OUTPUT_FILES}" >> ${PARAMFILE}
    echo "OutputDir         ${OUTPUTDIR}"           >> ${PARAMFILE}
    echo "RequestedNThreads ${THREADS}"             >> ${PARAMFILE}
    echo "N                 ${N}"                   >> ${PARAMFILE}

    echo "${PARAMFILE} written"
    
    return 0
}
