#!/bin/bash

######################### RESOURSE ALLOCATION #####################################
##SBATCH --account=????????

#SBATCH --partition=pleiadi
#SBATCH --job-name="Jacobi"
#SBATCH --nodes=1
#SBATCH --exclusive
#SBATCH --output=Jacobi-mpi-comp-comm-%j.out
#SBATCH --error=Jacobi-mpi-comp-comm.%j.err
#SBATCH --time=00:05:00
###################################################################################

################################## MODULES ########################################
export MODULE_VERSION=5.0.1
source /opt/cluster/spack/share/spack/setup-env.sh

# module purge
module purge
# load GCC
module load default-gcc-11.2.0
###################################################################################

# input parameters
source input_parameters

WORKDIR=${PWD}
# compile the application
cd .. && make clean && make mpi
if [[ "$?" != "0" ]]
then
    echo "Cannot compile the application ...aborting..."
    exit 1
fi

# get the executable
EXEC=$(find $(realpath ./) -maxdepth 1 -executable -name "jacobi_*" -type f -print)
if [[ "$?" != "0" ]]
then
    echo "Cannot find the executable ...aborting..."
    exit 2
fi

for TASK in ${TASKS[@]}
do
    # run the application
    time mpirun -n ${TASK} ${EXEC} ${GRID_SIZE_X} ${GRID_SIZE_Y} |& tee ${EXEC}_TASK_${TASK}_output.txt
done

cd ${WORKDIR}

exit 0
