#!/bin/bash

######################### RESOURSE ALLOCATION #####################################
#SBATCH --account=hpc_school
#SBATCH --partition=hpc_school
#SBATCH --job-name="Jacobi"
#SBATCH --nodes=1
#SBATCH --ntasks-per-node=1
#SBATCH --cpus-per-task=8
#SBATCH --output=Jacobi-omp-no-opt-%j.out
#SBATCH --error=Jacobi-omp-no-opt.%j.err
#SBATCH --time=00:05:00
###################################################################################

################################## MODULES ########################################
export MODULE_VERSION=5.0.1
source /opt/cluster/spack/share/spack/setup-env.sh

# module purge
module purge
# load GCC
module load default-gcc-11.2.0
###################################################################################

# input parameters
source input_parameters

WORKDIR=${PWD}
# compile the application
cd .. && make clean && make omp
if [[ "$?" != "0" ]]
then
    echo "Cannot compile the application ...aborting..."
    exit 1
fi

# get the executable
EXEC=$(find $(realpath ./) -maxdepth 1 -executable -name "jacobi_*" -type f -print)
if [[ "$?" != "0" ]]
then
    echo "Cannot find the executable ...aborting..."
    exit 2
fi


# OMP stuff
export OMP_DISPLAY_AFFINITY=1
export OMP_WAIT_POLICY=ACTIVE
# export OMP_PLACES=( "cores", "threads" )
# export BINDING=( "master" "close" "spread" )

for OMP in ${OMP_THREADS[@]}
do
    # not necessary because the clause 'num_threads'
    # is specified in the source code
    # export OMP_NUM_THREADS=${OMP}

    # run the application
    time ${EXEC} ${GRID_SIZE_X} ${GRID_SIZE_Y} ${OMP} |& tee ${EXEC}_OMP_${OMP}_output.txt
done
cd ${WORKDIR}

exit 0
