/* ///////////////////////////////////////////////////////////////////// */
/* Authors:  A. Mignone (mignone@to.infn.it)                             */
/*           V. Cesare  (valentina.cesare@inaf.it)                       */
/*           D. Goz     (david.goz@inaf.it)                              */
/*                                                                       */
/* Date   : June 2024                                                    */
/*                                                                       */
/* ///////////////////////////////////////////////////////////////////// */

#include "tools.h"

/* ********************************************************************* */
MyData **Allocate_2DdblArray(const int nx, const int ny)
/*
 * Allocate memory for a double precision array with
 * nx rows and ny columns
 *********************************************************************** */
{
  MyData **buf = malloc(nx * sizeof(MyData *));
  assert(buf != NULL);

  buf[0] = (MyData *) malloc(nx * ny * sizeof(MyData));
  assert(buf[0] != NULL);
  
  for (int j=1 ; j<nx ; j++)
    buf[j] = buf[j-1] + ny;
    
  return buf;
}

/* ********************************************************************* */
void Show_2DdblArray(const MyData **const A,
		     const int            nx,
		     const int            ny,
		     const char *const    string)
/* *********************************************************************** */
{
  printf ("%s\n",string);
  printf ("------------------------------\n");
  for (int i=0 ; i<nx ; i++)
    {
      for (int j=0 ; j<ny ; j++)
	{
	  printf ("%8.2f  ", A[i][j]);
	}
      printf ("\n");
    }
  printf ("------------------------------\n");
}
/* ********************************************************************* */

double seconds()
{
  struct timespec ts;
  return (clock_gettime( CLOCK_PROCESS_CPUTIME_ID, &ts ),
	   (double)ts.tv_sec +
	   (double)ts.tv_nsec * 1e-9);
}
