#!/bin/bash

######################### RESOURSE ALLOCATION #####################################
##SBATCH --account=????????

#SBATCH --partition=pleiadi
#SBATCH --job-name="Jabobi"
#SBATCH --nodes=1
#SBATCH --ntasks-per-node=1
#SBATCH --cpus-per-task=1
#SBATCH --output=Jacobi-serial-no-opt-%j.out
#SBATCH --error=Jacobi-serial-no-opt.%j.err
#SBATCH --time=00:03:00
###################################################################################

################################## MODULES ########################################
export MODULE_VERSION=5.0.1
source /opt/cluster/spack/share/spack/setup-env.sh

# module purge
module purge
# load GCC
module load default-gcc-11.2.0
###################################################################################

# input parameters
source input_parameters

WORKDIR=${PWD}
# compile the application
cd .. && make serial
if [[ "$?" != "0" ]]
then
    echo "Cannot compile the application ...aborting..."
    exit 1
fi

# get the executable
EXEC=$(find $(realpath ./) -maxdepth 1 -executable -name "jacobi_*" -type f -print)
if [[ "$?" != "0" ]]
then
    echo "Cannot find the executable ...aborting..."
    exit 2
fi


# run 
time ${EXEC} ${GRID_SIZE_X} ${GRID_SIZE_Y} |& tee ${EXEC}_output.txt

cd ${WORKDIR}

exit 0

# # return to ./script and source input parameters and function
# cd - && source input_parameters && source write_paramfile.sh

# # loop over particles
# for PART in "${N[@]}"
# do
#     # loop over MPI tasks
#     for TASK in "${MPI[@]}"
#     do
# 	# loop over OMP threads
# 	for THR in "${THREADS[@]}"
# 	do
# 	    # write the paramfile
# 	    write_paramfile ${TEMPLATE}      ${PARAMFILE}       \
# 			    ${DELETE_OUTPUT_FILES} ${OUTPUTDIR} \
# 			    ${THR} ${PART}

# 	    # check the status
# 	    if [[ "$?" != "0" ]]
# 	    then
# 		echo "Error while writing ${PARAMFILE} ...aborting..."
# 		exit 3
# 	    fi

# 	    # move the paramfile and move to the parent directory where the executable resides
# 	    mv ${PARAMFILE} ../ && cd ..
	    
# 	    # run the application
# 	    srun --ntasks ${TASK} ${EXEC} ${PARAMFILE} >& $SLURM_JOB_ID.log

# 	    # check exit status
# 	    if [[ "$?" != "0" ]]
# 	    then
# 		echo "####################################################################"
# 		echo "ERROR while running the app using: ${TASK} MPI tasks and ${GPU} GPUs"
# 		echo "####################################################################"
# 	    fi

# 	    # delete the paramfile and return to the previous directory
# 	    rm -f ${PARAMFILE} && cd -
# 	done # loop over THR
#     done # loop over TASKS
# done # looop over particles

# # make clean
# cd .. && make clean



# Everything is OK!
# exit 0
