#ifndef FILEWRAPPER_H
#define	FILEWRAPPER_H

#include <Configuration.h>

#include <tango.h>

#include <boost/filesystem.hpp>

namespace DataExporter_ns
{

class FileWrapper : public Tango::LogAdapter
{
public:
//------------------------------------------------------------------------------
//  [Public] Shared pointer typedef
//------------------------------------------------------------------------------
    typedef boost::shared_ptr<FileWrapper> SP;

protected:
//------------------------------------------------------------------------------
//  [Protected] Constructor destructor deleter
//------------------------------------------------------------------------------
    FileWrapper(Tango::DeviceImpl*, boost::filesystem::path&);

    virtual ~FileWrapper();

    class Deleter;
    friend class Deleter;
    class Deleter
    {
        public:
            void operator()(FileWrapper* d) { delete d; }
    };

public:
//------------------------------------------------------------------------------
//	[Public] Class creation method
//------------------------------------------------------------------------------
    static FileWrapper::SP create(Tango::DeviceImpl*, boost::filesystem::path&);

//------------------------------------------------------------------------------
//	[Public] Input stream methods
//------------------------------------------------------------------------------
    virtual bool isOpen();

    virtual bool isBad();

    virtual bool isCompleted();

    virtual void read(std::vector<char>&);

protected:
//------------------------------------------------------------------------------
//  [Protected] Class variables
//------------------------------------------------------------------------------
    //Input file size
    boost::uint64_t m_inputFileSize;

    //Input file stream
    std::ifstream m_inputFileStream;

    //Read buffer size
    static const boost::uint64_t BUFFER_SIZE = 1024;
};

}   //End of namespace

#endif	/* FILEWRAPPER_H */
