#include <PlainServer.h>
#include <PlainSession.h>

namespace DataExporter_ns
{

//==============================================================================
//      PlainServer::PlainServer()
//==============================================================================
PlainServer::PlainServer(Tango::DeviceImpl* deviceImpl_p,
    Configuration::SP configuration_sp) :
    Server::Server(deviceImpl_p, configuration_sp)
{
    DEBUG_STREAM << "PlainServer::PlainServer()" << endl;
}

//==============================================================================
//      PlainServer::~PlainServer()
//==============================================================================
PlainServer::~PlainServer()
{
    DEBUG_STREAM << "PlainServer::~PlainServer()" << endl;
}

//==============================================================================
//      PlainServer::create()
//==============================================================================
Server::SP PlainServer::create(Tango::DeviceImpl* deviceImpl_p,
    Configuration::SP configuration_sp)
{
    Server::SP s_sp(new PlainServer(deviceImpl_p, configuration_sp),
        PlainServer::Deleter());

    return s_sp;
}

//==============================================================================
//      PlainServer::startAccept()
//==============================================================================
void PlainServer::startAccept()
{
    DEBUG_STREAM << "PlainServer::startAccept()" << endl;

    Session::SP session_sp = PlainSession::create(m_deviceImpl_p,
        m_configuration_sp, m_dBManager_sp, m_ioService_sp);

    m_acceptor_sp->async_accept(session_sp->getSocket(),
        boost::bind(&PlainServer::handleAccept, this,
        session_sp, boost::asio::placeholders::error));
}

}   //namespace
