#ifndef SERVER_H
#define	SERVER_H

#include <Configuration.h>
#include <DBManager.h>
#include <Session.h>

#include <tango.h>

#include <boost/shared_ptr.hpp>
#include <boost/asio.hpp>
#include <boost/thread.hpp>

namespace DataExporter_ns
{

class Server : public Tango::LogAdapter
{
public:
//------------------------------------------------------------------------------
//  [Public] Shared pointer typedef
//------------------------------------------------------------------------------
    typedef boost::shared_ptr<Server> SP;

protected:
//------------------------------------------------------------------------------
//	[Protected] Constructor destructor
//------------------------------------------------------------------------------
    Server(Tango::DeviceImpl*, Configuration::SP);

    virtual ~Server();

public:
//------------------------------------------------------------------------------
//	[Public] Thread management methods
//------------------------------------------------------------------------------
    virtual void start() /*throw(std::runtime_error)*/;

    virtual void stop() /*throw(std::runtime_error)*/;

//------------------------------------------------------------------------------
//	[Public] Read state and status methods
//------------------------------------------------------------------------------
    virtual Tango::DevState readState();

    virtual std::string readStatus();

protected:
//------------------------------------------------------------------------------
//  [Protected] Write state and status methods
//------------------------------------------------------------------------------
    virtual void writeState(Tango::DevState);

    virtual void writeStatus(std::string);

//------------------------------------------------------------------------------
//  [Protected] Incoming connection methods
//------------------------------------------------------------------------------
    virtual void startAccept() = 0;

    virtual void handleAccept(Session::SP, const boost::system::error_code&);

//------------------------------------------------------------------------------
//	[Protected] Class variables
//------------------------------------------------------------------------------
    //Device server base class pointer
    Tango::DeviceImpl* m_deviceImpl_p;

    //Configuration parameters shared pointer
    Configuration::SP m_configuration_sp;

    //Database data access class
    DBManager::SP m_dBManager_sp;

    //Io service used for async operations
    boost::shared_ptr<boost::asio::io_service> m_ioService_sp;

    //Prevents io service to run out of work and return
    boost::shared_ptr<boost::asio::io_service::work> m_work_sp;

    //Acceptor for incoming connection
    boost::shared_ptr<boost::asio::ip::tcp::acceptor> m_acceptor_sp;

    //Thread group container shared pointer
    boost::shared_ptr<boost::thread_group> m_threadGroup_sp;

    //Tango state property mutex
    boost::mutex m_stateMutex;

    //Tango state property
    Tango::DevState m_state;

    //Tango status property mutex
    boost::mutex m_statusMutex;

    //Tango status property
    std::string m_status;
};

}   //End of namespace

#endif	/* SERVER_H */

