#include <SSLServer.h>
#include <SSLSession.h>

#include <boost/bind.hpp>

namespace DataExporter_ns
{

//==============================================================================
//      SSLServer::SSLServer()
//==============================================================================
SSLServer::SSLServer(Tango::DeviceImpl* deviceImpl_p,
    Configuration::SP configuration_sp) :
    Server::Server(deviceImpl_p, configuration_sp)
{
    DEBUG_STREAM << "SSLServer::SSLServer()" << endl;

    m_context_sp.reset(new boost::asio::ssl::context(boost::asio::ssl::context::sslv23));

    m_context_sp->set_options(boost::asio::ssl::context::default_workarounds |
        boost::asio::ssl::context::no_sslv2 |
        boost::asio::ssl::context::single_dh_use);

    //@todo: ssl certificate password
    m_context_sp->set_password_callback(boost::bind(&SSLServer::getPassword, this));

    std::string certificateFile = m_configuration_sp->getCertificateFile();
    std::string privateKey = m_configuration_sp->getPrivateKeyFile();
    std::string dHTempFile = m_configuration_sp->getDHTempFile();

    INFO_STREAM << "SSLServer::SSLServer() Certificate " << certificateFile << endl;
    INFO_STREAM << "SSLServer::SSLServer() Private key " << privateKey << endl;
    INFO_STREAM << "SSLServer::SSLServer() DH Temporary " << dHTempFile << endl;

    //@todo: check error_code  use in load file methods
    m_context_sp->use_certificate_chain_file(certificateFile);
    m_context_sp->use_private_key_file(privateKey, boost::asio::ssl::context::pem);
    m_context_sp->use_tmp_dh_file(dHTempFile);
}

//==============================================================================
//      SSLServer::~SSLServer()
//==============================================================================
SSLServer::~SSLServer()
{
    DEBUG_STREAM << "SSLServer::~SSLServer()" << endl;
}

//==============================================================================
//      SSLServer::create()
//==============================================================================
Server::SP SSLServer::create(Tango::DeviceImpl* deviceImpl_p,
    Configuration::SP configuration_sp)
{
    Server::SP s_sp(new SSLServer(deviceImpl_p, configuration_sp),
        SSLServer::Deleter());

    return s_sp;
}

//==============================================================================
//      SSLServer::startAccept()
//==============================================================================
void SSLServer::startAccept()
{
    DEBUG_STREAM << "SSLServer::startAccept()" << endl;

    Session::SP session_sp = SSLSession::create(m_deviceImpl_p,
        m_configuration_sp, m_dBManager_sp, m_ioService_sp, m_context_sp);

    m_acceptor_sp->async_accept(session_sp->getSocket(),
        boost::bind(&SSLServer::handleAccept, this,
        session_sp, boost::asio::placeholders::error));
}

//==============================================================================
//      SSLServer::startAccept()
//==============================================================================
std::string SSLServer::getPassword()
{
    DEBUG_STREAM << "SSLServer::getPassword()" << endl;

    return "test";
}

}   //namespace
