/*----- PROTECTED REGION ID(DataExporter.h) ENABLED START -----*/
//=============================================================================
//
// file :        DataExporter.h
//
// description : Include file for the DataExporter class
//
// project :     Data exporter
//
// This file is part of Tango device class.
//
// Tango is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Tango is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Tango.  If not, see <http://www.gnu.org/licenses/>.
//
// $Author:  $
//
// $Revision:  $
// $Date:  $
//
// $HeadURL:  $
//
//=============================================================================
//                This file is generated by POGO
//        (Program Obviously used to Generate tango Object)
//=============================================================================


#ifndef DataExporter_H
#define DataExporter_H

#include <Configuration.h>
#include <Server.h>

#include <tango.h>


/*----- PROTECTED REGION END -----*/	//	DataExporter.h

/**
 *  DataExporter class description:
 *    
 */

namespace DataExporter_ns
{
/*----- PROTECTED REGION ID(DataExporter::Additional Class Declarations) ENABLED START -----*/

//	Additional Class Declarations

/*----- PROTECTED REGION END -----*/	//	DataExporter::Additional Class Declarations

class DataExporter : public TANGO_BASE_CLASS
{

/*----- PROTECTED REGION ID(DataExporter::Data Members) ENABLED START -----*/

//------------------------------------------------------------------------------
//  [Protected] Class variables
//------------------------------------------------------------------------------
    //Configuration class shared pointer
    Configuration::SP m_configuration_sp;

    //Server base class shared pointer
    Server::SP m_server_sp;

    //Max port number allowed value
    static const unsigned int MAX_PORT_NUMBER = 65535;

    //Max number of worker thread allowed
    static const unsigned int MAX_WORKER_NUMBER = 100;

    //Max number of database connection allowed
    static const unsigned int MAX_DB_CONNECTION_NUMBER = 100;


/*----- PROTECTED REGION END -----*/	//	DataExporter::Data Members

//	Device property data members
public:
	//	CertificateFile:	Absolute path to certificate chain file
	string	certificateFile;
	//	PrivateKeyFile:	Absolute path to private key file
	string	privateKeyFile;
	//	DHTempFile:	Absolute path to Diffie Hellman temporary file
	string	dHTempFile;
	//	ExportedTables:	Tables exported from database: one table per row
	//  [schema table]
	vector<string>	exportedTables;
	//	AuthorisedUsers:	Authorised user list: one user per row
	//  [username password]
	vector<string>	authorisedUsers;
	//	LocalHost:	Local host address for incoming connection
	string	localHost;
	//	LocalPort:	Local port for wait incoming connection
	Tango::DevULong	localPort;
	//	WorkerNumber:	Number of threads that call io service run methods
	Tango::DevUShort	workerNumber;
	//	EnableSSL:	Enable or disable SSL connections
	Tango::DevBoolean	enableSSL;
	//	DatabaseHost:	Metadata database host
	string	databaseHost;
	//	DatabasePort:	Metadata database port
	Tango::DevULong	databasePort;
	//	DatabaseUsername:	Metadata database login username
	string	databaseUsername;
	//	DatabasePassword:	Metadata database login password
	string	databasePassword;
	//	DatabaseConnectionNumber:	Number of database connection created
	Tango::DevUShort	databaseConnectionNumber;
	//	AutoStart:	Exec On command after init if state is not fault
	Tango::DevBoolean	autoStart;


//	Constructors and destructors
public:
	/**
	 * Constructs a newly device object.
	 *
	 *	@param cl	Class.
	 *	@param s 	Device Name
	 */
	DataExporter(Tango::DeviceClass *cl,string &s);
	/**
	 * Constructs a newly device object.
	 *
	 *	@param cl	Class.
	 *	@param s 	Device Name
	 */
	DataExporter(Tango::DeviceClass *cl,const char *s);
	/**
	 * Constructs a newly device object.
	 *
	 *	@param cl	Class.
	 *	@param s 	Device name
	 *	@param d	Device description.
	 */
	DataExporter(Tango::DeviceClass *cl,const char *s,const char *d);
	/**
	 * The device object destructor.
	 */	
	~DataExporter() {delete_device();};


//	Miscellaneous methods
public:
	/*
	 *	will be called at device destruction or at init command.
	 */
	void delete_device();
	/*
	 *	Initialize the device
	 */
	virtual void init_device();
	/*
	 *	Read the device properties from database
	 */
	void get_device_property();
	/*
	 *	Always executed method before execution command method.
	 */
	virtual void always_executed_hook();


//	Attribute methods
public:
	//--------------------------------------------------------
	/*
	 *	Method      : DataExporter::read_attr_hardware()
	 *	Description : Hardware acquisition for attributes.
	 */
	//--------------------------------------------------------
	virtual void read_attr_hardware(vector<long> &attr_list);


	//--------------------------------------------------------
	/**
	 *	Method      : DataExporter::add_dynamic_attributes()
	 *	Description : Add dynamic attributes if any.
	 */
	//--------------------------------------------------------
	void add_dynamic_attributes();



//	Command related methods
public:
	/**
	 *	Command On related method
	 *	Description: Activate data exporter
	 *
	 */
	virtual void on();
	virtual bool is_On_allowed(const CORBA::Any &any);
	/**
	 *	Command Off related method
	 *	Description: Deactivate data exporter
	 *
	 */
	virtual void off();
	virtual bool is_Off_allowed(const CORBA::Any &any);


/*----- PROTECTED REGION ID(DataExporter::Additional Method prototypes) ENABLED START -----*/

//------------------------------------------------------------------------------
//  [Protected] Utilities methods
//------------------------------------------------------------------------------
    virtual void importExportedTables(std::vector<std::string>&,
        std::multimap<const std::string, const std::string>&)
        /*throw(std::invalid_argument)*/;

    virtual void importAuthorisedUsers(std::vector<std::string>&,
        std::map<const std::string, const std::string>&)
        /*throw(std::invalid_argument)*/;

    virtual void checkIfFileExists(std::string)
        /*throw(std::invalid_argument)*/;

/*----- PROTECTED REGION END -----*/	//	DataExporter::Additional Method prototypes
};

/*----- PROTECTED REGION ID(DataExporter::Additional Classes Definitions) ENABLED START -----*/

//	Additional Classes Definitions

/*----- PROTECTED REGION END -----*/	//	DataExporter::Additional Classes Definitions

}	//	End of namespace

#endif   //	DataExporter_H
