/*----- PROTECTED REGION ID(DataImporter.h) ENABLED START -----*/
//=============================================================================
//
// file :        DataImporter.h
//
// description : Include file for the DataImporter class
//
// project :     Data importer
//
// This file is part of Tango device class.
//
// Tango is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Tango is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Tango.  If not, see <http://www.gnu.org/licenses/>.
//
// $Author:  $
//
// $Revision:  $
// $Date:  $
//
// $HeadURL:  $
//
//=============================================================================
//                This file is generated by POGO
//        (Program Obviously used to Generate tango Object)
//=============================================================================


#ifndef DataImporter_H
#define DataImporter_H

#include <Configuration.h>
#include <Client.h>

#include <tango.h>


/*----- PROTECTED REGION END -----*/	//	DataImporter.h

/**
 *  DataImporter class description:
 *    
 */

namespace DataImporter_ns
{
/*----- PROTECTED REGION ID(DataImporter::Additional Class Declarations) ENABLED START -----*/

//	Additional Class Declarations

/*----- PROTECTED REGION END -----*/	//	DataImporter::Additional Class Declarations

class DataImporter : public TANGO_BASE_CLASS
{

/*----- PROTECTED REGION ID(DataImporter::Data Members) ENABLED START -----*/

//------------------------------------------------------------------------------
//  [Private] Class variables
//------------------------------------------------------------------------------
    //Configuration class shared pointer
    Configuration::SP m_configuration_sp;

    //Client class shared pointer
    Client::SP m_client_sp;

    //Regular file counter synchronization
    boost::mutex m_regularCounterMutex;

    //Failed file counter synchronization
    boost::mutex m_failedCounterMutex;

    //Max port number allowed value for data import database
    static const unsigned int MAX_PORT_NUMBER = 65535;

    //Max time between remote server requests
    static const unsigned int MAX_REFRESH_TIME = 3600;

    //Max time between remote server request and response
    static const unsigned int MAX_TIMEOUT = 60;

    //Time between failed download attempt
    static const unsigned int MAX_RECOVERY_TIME = 86400;

/*----- PROTECTED REGION END -----*/	//	DataImporter::Data Members

//	Device property data members
public:
	//	CertificateFile:	Absolute path to certificate chain file
	string	certificateFile;
	//	StoragePath:	Absolute path to storage
	string	storagePath;
	//	RemoteHost:	Metadata exporter remote host
	string	remoteHost;
	//	RemotePort:	Metadata exporter remote port
	Tango::DevULong	remotePort;
	//	RemoteUsername:	Metadata exporter login username
	string	remoteUsername;
	//	RemotePassword:	Metadata exporter remote password
	string	remotePassword;
	//	RemoteSchema:	Metadata remote database schema
	string	remoteSchema;
	//	RemoteTable:	Metadata remote database table
	string	remoteTable;
	//	EnableSSL:	Enable or disable SSL connections
	Tango::DevBoolean	enableSSL;
	//	DatabaseHost:	Metadata local database host
	string	databaseHost;
	//	DatabasePort:	Metadata local database port
	Tango::DevULong	databasePort;
	//	DatabaseUsername:	Metadata local database username
	string	databaseUsername;
	//	DatabasePassword:	Metadata local database password
	string	databasePassword;
	//	DatabaseSchema:	Metadata local database schema
	string	databaseSchema;
	//	DatabaseTable:	Metadata local database table
	string	databaseTable;
	//	RefreshTime:	Local database request period (seconds)
	Tango::DevULong	refreshTime;
	//	Timeout:	Connection timeout (seconds)
	Tango::DevULong	timeout;
	//	RecoveryTime:	Time between failed file download attempt
	Tango::DevULong	recoveryTime;
	//	AutoStart:	Exec On command after init if state is not fault
	Tango::DevBoolean	autoStart;
	//	AuxDatabaseHost:	File transfer auxiliary database host
	string	auxDatabaseHost;
	//	AuxDatabasePort:	File transfer auxiliary database port
	Tango::DevULong	auxDatabasePort;
	//	AuxDatabaseUsername:	File transfer auxiliary database username
	string	auxDatabaseUsername;
	//	AuxDatabasePassword:	File transfer auxiliary database password
	string	auxDatabasePassword;
	//	AuxDatabaseSchema:	File transfer auxiliary database schema
	string	auxDatabaseSchema;
	//	AuxDatabaseTimestampTable:	File transfer auxiliary database device timestamp table
	string	auxDatabaseTimestampTable;
	//	AuxDatabaseFailedTable:	File transfer auxiliary database failed transfer table
	string	auxDatabaseFailedTable;
	//	WhereCondition:	Files retrieval sql where condition
	string	whereCondition;

//	Attribute data members
public:
	Tango::DevULong	*attr_RegularFileCounter_read;
	Tango::DevULong	*attr_FailedFileCounter_read;

//	Constructors and destructors
public:
	/**
	 * Constructs a newly device object.
	 *
	 *	@param cl	Class.
	 *	@param s 	Device Name
	 */
	DataImporter(Tango::DeviceClass *cl,string &s);
	/**
	 * Constructs a newly device object.
	 *
	 *	@param cl	Class.
	 *	@param s 	Device Name
	 */
	DataImporter(Tango::DeviceClass *cl,const char *s);
	/**
	 * Constructs a newly device object.
	 *
	 *	@param cl	Class.
	 *	@param s 	Device name
	 *	@param d	Device description.
	 */
	DataImporter(Tango::DeviceClass *cl,const char *s,const char *d);
	/**
	 * The device object destructor.
	 */	
	~DataImporter() {delete_device();};


//	Miscellaneous methods
public:
	/*
	 *	will be called at device destruction or at init command.
	 */
	void delete_device();
	/*
	 *	Initialize the device
	 */
	virtual void init_device();
	/*
	 *	Read the device properties from database
	 */
	void get_device_property();
	/*
	 *	Always executed method before execution command method.
	 */
	virtual void always_executed_hook();


//	Attribute methods
public:
	//--------------------------------------------------------
	/*
	 *	Method      : DataImporter::read_attr_hardware()
	 *	Description : Hardware acquisition for attributes.
	 */
	//--------------------------------------------------------
	virtual void read_attr_hardware(vector<long> &attr_list);

/**
 *	Attribute RegularFileCounter related methods
 *	Description: 
 *
 *	Data type:	Tango::DevULong
 *	Attr type:	Scalar
 */
	virtual void read_RegularFileCounter(Tango::Attribute &attr);
	virtual bool is_RegularFileCounter_allowed(Tango::AttReqType type);
/**
 *	Attribute FailedFileCounter related methods
 *	Description: 
 *
 *	Data type:	Tango::DevULong
 *	Attr type:	Scalar
 */
	virtual void read_FailedFileCounter(Tango::Attribute &attr);
	virtual bool is_FailedFileCounter_allowed(Tango::AttReqType type);


	//--------------------------------------------------------
	/**
	 *	Method      : DataImporter::add_dynamic_attributes()
	 *	Description : Add dynamic attributes if any.
	 */
	//--------------------------------------------------------
	void add_dynamic_attributes();



//	Command related methods
public:
	/**
	 *	Command On related method
	 *	Description: Activate data importer
	 *
	 */
	virtual void on();
	virtual bool is_On_allowed(const CORBA::Any &any);
	/**
	 *	Command Off related method
	 *	Description: Deactivate data importer
	 *
	 */
	virtual void off();
	virtual bool is_Off_allowed(const CORBA::Any &any);
	/**
	 *	Command ResetCounter related method
	 *	Description: 
	 *
	 */
	virtual void reset_counter();
	virtual bool is_ResetCounter_allowed(const CORBA::Any &any);


/*----- PROTECTED REGION ID(DataImporter::Additional Method prototypes) ENABLED START -----*/

//------------------------------------------------------------------------------
//  [Public] Counters methods
//------------------------------------------------------------------------------
    virtual void incrementRegularCounter();

    virtual void incrementFailedCounter();

    virtual void decrementFailedCounter();

protected:
//------------------------------------------------------------------------------
//  [Protected] Utilities methods
//------------------------------------------------------------------------------
    virtual void checkIfFileExists(std::string)
        /*throw(std::invalid_argument)*/;

    virtual void checkIfDirectoryExists(std::string)
        /*throw(std::invalid_argument)*/;

/*----- PROTECTED REGION END -----*/	//	DataImporter::Additional Method prototypes
};

/*----- PROTECTED REGION ID(DataImporter::Additional Classes Definitions) ENABLED START -----*/

//	Additional Classes Definitions

/*----- PROTECTED REGION END -----*/	//	DataImporter::Additional Classes Definitions

}	//	End of namespace

#endif   //	DataImporter_H
