/*----- PROTECTED REGION ID(DataImporterClass.h) ENABLED START -----*/
//=============================================================================
//
// file :        DataImporterClass.h
//
// description : Include for the DataImporter root class.
//               This class is the singleton class for
//                the DataImporter device class.
//               It contains all properties and methods which the 
//               DataImporter requires only once e.g. the commands.
//
// project :     Data importer
//
// This file is part of Tango device class.
// 
// Tango is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// Tango is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with Tango.  If not, see <http://www.gnu.org/licenses/>.
// 
// $Author:  $
//
// $Revision:  $
// $Date:  $
//
// $HeadURL:  $
//
//=============================================================================
//                This file is generated by POGO
//        (Program Obviously used to Generate tango Object)
//=============================================================================


#ifndef DataImporterClass_H
#define DataImporterClass_H

#include <tango.h>
#include <DataImporter.h>


/*----- PROTECTED REGION END -----*/	//	DataImporterClass.h


namespace DataImporter_ns
{
/*----- PROTECTED REGION ID(DataImporterClass::classes for dynamic creation) ENABLED START -----*/


/*----- PROTECTED REGION END -----*/	//	DataImporterClass::classes for dynamic creation

//=========================================
//	Define classes for attributes
//=========================================
//	Attribute RegularFileCounter class definition
class RegularFileCounterAttrib: public Tango::Attr
{
public:
	RegularFileCounterAttrib():Attr("RegularFileCounter",
			Tango::DEV_ULONG, Tango::READ) {};
	~RegularFileCounterAttrib() {};
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
		{(static_cast<DataImporter *>(dev))->read_RegularFileCounter(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<DataImporter *>(dev))->is_RegularFileCounter_allowed(ty);}
};

//	Attribute FailedFileCounter class definition
class FailedFileCounterAttrib: public Tango::Attr
{
public:
	FailedFileCounterAttrib():Attr("FailedFileCounter",
			Tango::DEV_ULONG, Tango::READ) {};
	~FailedFileCounterAttrib() {};
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
		{(static_cast<DataImporter *>(dev))->read_FailedFileCounter(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<DataImporter *>(dev))->is_FailedFileCounter_allowed(ty);}
};


//=========================================
//	Define classes for commands
//=========================================
//	Command On class definition
class OnClass : public Tango::Command
{
public:
	OnClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	OnClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~OnClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataImporter *>(dev))->is_On_allowed(any);}
};

//	Command Off class definition
class OffClass : public Tango::Command
{
public:
	OffClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	OffClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~OffClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataImporter *>(dev))->is_Off_allowed(any);}
};

//	Command ResetCounter class definition
class ResetCounterClass : public Tango::Command
{
public:
	ResetCounterClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	ResetCounterClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~ResetCounterClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<DataImporter *>(dev))->is_ResetCounter_allowed(any);}
};


/**
 *	The DataImporterClass singleton definition
 */

#ifdef _TG_WINDOWS_
class __declspec(dllexport)  DataImporterClass : public Tango::DeviceClass
#else
class DataImporterClass : public Tango::DeviceClass
#endif
{
	/*----- PROTECTED REGION ID(DataImporterClass::Additionnal DServer data members) ENABLED START -----*/
	
	
	/*----- PROTECTED REGION END -----*/	//	DataImporterClass::Additionnal DServer data members

	//	Class properties data members
	public:
		//	CertificateFile:	Absolute path to certificate chain file
		string	certificateFile;
		//	StoragePath:	Absolute path to storage
		string	storagePath;
		//	AuxDatabaseHost:	File transfer auxiliary database host
		string	auxDatabaseHost;
		//	AuxDatabasePort:	File transfer auxiliary database port
		Tango::DevULong	auxDatabasePort;
		//	AuxDatabaseUsername:	File transfer auxiliary database username
		string	auxDatabaseUsername;
		//	AuxDatabasePassword:	File transfer auxiliary database password
		string	auxDatabasePassword;
		//	AuxDatabaseSchema:	File transfer auxiliary database schema
		string	auxDatabaseSchema;
		//	AuxDatabaseTimestampTable:	File transfer auxiliary database device timestamp table
		string	auxDatabaseTimestampTable;
		//	AuxDatabaseFailedTable:	File transfer auxiliary database failed transfer table
		string	auxDatabaseFailedTable;
	public:
		//	write class properties data members
		Tango::DbData	cl_prop;
		Tango::DbData	cl_def_prop;
		Tango::DbData	dev_def_prop;
	
		//	Method prototypes
		static DataImporterClass *init(const char *);
		static DataImporterClass *instance();
		~DataImporterClass();
		Tango::DbDatum	get_class_property(string &);
		Tango::DbDatum	get_default_device_property(string &);
		Tango::DbDatum	get_default_class_property(string &);
	
	protected:
		DataImporterClass(string &);
		static DataImporterClass *_instance;
		void command_factory();
		void attribute_factory(vector<Tango::Attr *> &);
		void write_class_property();
		void set_default_property();
		void get_class_property();
		string get_cvstag();
		string get_cvsroot();
	
	private:
		void device_factory(const Tango::DevVarStringArray *);
		void create_static_attribute_list(vector<Tango::Attr *> &);
		void erase_dynamic_attributes(const Tango::DevVarStringArray *,vector<Tango::Attr *> &);
		vector<string>	defaultAttList;
		Tango::Attr *get_attr_object_by_name(vector<Tango::Attr *> &att_list, string attname);
};

}	//	End of namespace

#endif   //	DataImporter_H
