/*----- PROTECTED REGION ID(DataImporter.cpp) ENABLED START -----*/
//=============================================================================
//
// file :        DataImporter.cpp
//
// description : C++ source for the DataImporter class and its commands.
//               The class is derived from Device. It represents the
//               CORBA servant object which will be accessed from the
//               network. All commands which can be executed on the
//               DataImporter are implemented in this file.
//
// project :     Data importer
//
// This file is part of Tango device class.
//
// Tango is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Tango is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Tango.  If not, see <http://www.gnu.org/licenses/>.
//
// $Author:  $
//
// $Revision:  $
// $Date:  $
//
// $HeadURL:  $
//
//=============================================================================
//                This file is generated by POGO
//        (Program Obviously used to Generate tango Object)
//=============================================================================


#include <DataImporter.h>
#include <DataImporterClass.h>
#include <PlainClient.h>
#include <SSLClient.h>

#include <boost/filesystem.hpp>

/*----- PROTECTED REGION END -----*/	//	DataImporter.cpp

/**
 *  DataImporter class description:
 *
 */

//================================================================
//  The following table gives the correspondence
//  between command and method names.
//
//  Command name  |  Method name
//================================================================
//  State         |  Inherited (no method)
//  Status        |  Inherited (no method)
//  On            |  on
//  Off           |  off
//================================================================

//================================================================
//  Attributes managed is:
//================================================================
//================================================================

namespace DataImporter_ns
{
/*----- PROTECTED REGION ID(DataImporter::namespace_starting) ENABLED START -----*/

//	static initializations

/*----- PROTECTED REGION END -----*/	//	DataImporter::namespace_starting

//--------------------------------------------------------
/**
 *	Method      : DataImporter::DataImporter()
 *	Description : Constructors for a Tango device
 *                implementing the classDataImporter
 */
//--------------------------------------------------------
DataImporter::DataImporter(Tango::DeviceClass *cl, string &s)
 : TANGO_BASE_CLASS(cl, s.c_str())
{
	/*----- PROTECTED REGION ID(DataImporter::constructor_1) ENABLED START -----*/
	init_device();

	/*----- PROTECTED REGION END -----*/	//	DataImporter::constructor_1
}
//--------------------------------------------------------
DataImporter::DataImporter(Tango::DeviceClass *cl, const char *s)
 : TANGO_BASE_CLASS(cl, s)
{
	/*----- PROTECTED REGION ID(DataImporter::constructor_2) ENABLED START -----*/
	init_device();

	/*----- PROTECTED REGION END -----*/	//	DataImporter::constructor_2
}
//--------------------------------------------------------
DataImporter::DataImporter(Tango::DeviceClass *cl, const char *s, const char *d)
 : TANGO_BASE_CLASS(cl, s, d)
{
	/*----- PROTECTED REGION ID(DataImporter::constructor_3) ENABLED START -----*/
	init_device();

	/*----- PROTECTED REGION END -----*/	//	DataImporter::constructor_3
}

//--------------------------------------------------------
/**
 *	Method      : DataImporter::delete_device()
 *	Description : will be called at device destruction or at init command
 */
//--------------------------------------------------------
void DataImporter::delete_device()
{
	DEBUG_STREAM << "DataImporter::delete_device() " << device_name << endl;
	/*----- PROTECTED REGION ID(DataImporter::delete_device) ENABLED START -----*/

	//	Delete device allocated objects

	/*----- PROTECTED REGION END -----*/	//	DataImporter::delete_device
}

//--------------------------------------------------------
/**
 *	Method      : DataImporter::init_device()
 *	Description : will be called at device initialization.
 */
//--------------------------------------------------------
void DataImporter::init_device()
{
	DEBUG_STREAM << "DataImporter::init_device() create device " << device_name << endl;
	/*----- PROTECTED REGION ID(DataImporter::init_device_before) ENABLED START -----*/

    set_state(Tango::INIT);
    set_status("Initializing device");

	/*----- PROTECTED REGION END -----*/	//	DataImporter::init_device_before


	//	Get the device properties from database
	get_device_property();


	/*----- PROTECTED REGION ID(DataImporter::init_device) ENABLED START -----*/

    if(get_state() != Tango::FAULT)
    {
        try
        {
            if(enableSSL)
                m_client_sp = SSLClient::create(this, m_configuration_sp);
            else
                m_client_sp = PlainClient::create(this, m_configuration_sp);

            //Start device if auto start enabled
            if(autoStart)
            {
                INFO_STREAM << "FitsImporter::init_device() auto start enabled " << endl;
                on();
            }
        }
        catch(std::exception& ex)
        {
            set_state(Tango::FAULT);
            std::stringstream error_stream;
            error_stream << "DataImporter::init_device() " << ex.what() << std::endl;
            set_status(error_stream.str());
        }
        catch(...)
        {
            set_state(Tango::FAULT);
            set_status("DataImporter::init_device() unknown error");
        }
    }

	/*----- PROTECTED REGION END -----*/	//	DataImporter::init_device
}

//--------------------------------------------------------
/**
 *	Method      : DataImporter::get_device_property()
 *	Description : Read database to initialize property data members.
 */
//--------------------------------------------------------
void DataImporter::get_device_property()
{
	/*----- PROTECTED REGION ID(DataImporter::get_device_property_before) ENABLED START -----*/

	//	Initialize property data members

	/*----- PROTECTED REGION END -----*/	//	DataImporter::get_device_property_before


	//	Read device properties from database.
	Tango::DbData	dev_prop;
	dev_prop.push_back(Tango::DbDatum("CertificateFile"));
	dev_prop.push_back(Tango::DbDatum("StoragePath"));
	dev_prop.push_back(Tango::DbDatum("RemoteHost"));
	dev_prop.push_back(Tango::DbDatum("RemotePort"));
	dev_prop.push_back(Tango::DbDatum("RemoteUsername"));
	dev_prop.push_back(Tango::DbDatum("RemotePassword"));
	dev_prop.push_back(Tango::DbDatum("EnableSSL"));
	dev_prop.push_back(Tango::DbDatum("DatabaseHost"));
	dev_prop.push_back(Tango::DbDatum("DatabasePort"));
	dev_prop.push_back(Tango::DbDatum("DatabaseUsername"));
	dev_prop.push_back(Tango::DbDatum("DatabasePassword"));
	dev_prop.push_back(Tango::DbDatum("DatabaseSchema"));
	dev_prop.push_back(Tango::DbDatum("DatabaseTable"));
	dev_prop.push_back(Tango::DbDatum("RefreshTime"));
	dev_prop.push_back(Tango::DbDatum("Timeout"));
	dev_prop.push_back(Tango::DbDatum("RecoveryTime"));
	dev_prop.push_back(Tango::DbDatum("AutoStart"));
	dev_prop.push_back(Tango::DbDatum("AuxDatabaseHost"));
	dev_prop.push_back(Tango::DbDatum("AuxDatabasePort"));
	dev_prop.push_back(Tango::DbDatum("AuxDatabaseUsername"));
	dev_prop.push_back(Tango::DbDatum("AuxDatabasePassword"));
	dev_prop.push_back(Tango::DbDatum("AuxDatabaseSchema"));
	dev_prop.push_back(Tango::DbDatum("AuxDatabaseTimestampTable"));
	dev_prop.push_back(Tango::DbDatum("AuxDatabaseFailedTable"));

	//	is there at least one property to be read ?
	if (dev_prop.size()>0)
	{
		//	Call database and extract values
		if (Tango::Util::instance()->_UseDb==true)
			get_db_device()->get_property(dev_prop);

		//	get instance on DataImporterClass to get class property
		Tango::DbDatum	def_prop, cl_prop;
		DataImporterClass	*ds_class =
			(static_cast<DataImporterClass *>(get_device_class()));
		int	i = -1;

		//	Try to initialize CertificateFile from class property
		cl_prop = ds_class->get_class_property(dev_prop[++i].name);
		if (cl_prop.is_empty()==false)	cl_prop  >>  certificateFile;
		else {
			//	Try to initialize CertificateFile from default device value
			def_prop = ds_class->get_default_device_property(dev_prop[i].name);
			if (def_prop.is_empty()==false)	def_prop  >>  certificateFile;
		}
		//	And try to extract CertificateFile value from database
		if (dev_prop[i].is_empty()==false)	dev_prop[i]  >>  certificateFile;

		//	Try to initialize StoragePath from class property
		cl_prop = ds_class->get_class_property(dev_prop[++i].name);
		if (cl_prop.is_empty()==false)	cl_prop  >>  storagePath;
		else {
			//	Try to initialize StoragePath from default device value
			def_prop = ds_class->get_default_device_property(dev_prop[i].name);
			if (def_prop.is_empty()==false)	def_prop  >>  storagePath;
		}
		//	And try to extract StoragePath value from database
		if (dev_prop[i].is_empty()==false)	dev_prop[i]  >>  storagePath;

		//	Try to initialize RemoteHost from class property
		cl_prop = ds_class->get_class_property(dev_prop[++i].name);
		if (cl_prop.is_empty()==false)	cl_prop  >>  remoteHost;
		else {
			//	Try to initialize RemoteHost from default device value
			def_prop = ds_class->get_default_device_property(dev_prop[i].name);
			if (def_prop.is_empty()==false)	def_prop  >>  remoteHost;
		}
		//	And try to extract RemoteHost value from database
		if (dev_prop[i].is_empty()==false)	dev_prop[i]  >>  remoteHost;

		//	Try to initialize RemotePort from class property
		cl_prop = ds_class->get_class_property(dev_prop[++i].name);
		if (cl_prop.is_empty()==false)	cl_prop  >>  remotePort;
		else {
			//	Try to initialize RemotePort from default device value
			def_prop = ds_class->get_default_device_property(dev_prop[i].name);
			if (def_prop.is_empty()==false)	def_prop  >>  remotePort;
		}
		//	And try to extract RemotePort value from database
		if (dev_prop[i].is_empty()==false)	dev_prop[i]  >>  remotePort;

		//	Try to initialize RemoteUsername from class property
		cl_prop = ds_class->get_class_property(dev_prop[++i].name);
		if (cl_prop.is_empty()==false)	cl_prop  >>  remoteUsername;
		else {
			//	Try to initialize RemoteUsername from default device value
			def_prop = ds_class->get_default_device_property(dev_prop[i].name);
			if (def_prop.is_empty()==false)	def_prop  >>  remoteUsername;
		}
		//	And try to extract RemoteUsername value from database
		if (dev_prop[i].is_empty()==false)	dev_prop[i]  >>  remoteUsername;

		//	Try to initialize RemotePassword from class property
		cl_prop = ds_class->get_class_property(dev_prop[++i].name);
		if (cl_prop.is_empty()==false)	cl_prop  >>  remotePassword;
		else {
			//	Try to initialize RemotePassword from default device value
			def_prop = ds_class->get_default_device_property(dev_prop[i].name);
			if (def_prop.is_empty()==false)	def_prop  >>  remotePassword;
		}
		//	And try to extract RemotePassword value from database
		if (dev_prop[i].is_empty()==false)	dev_prop[i]  >>  remotePassword;

		//	Try to initialize EnableSSL from class property
		cl_prop = ds_class->get_class_property(dev_prop[++i].name);
		if (cl_prop.is_empty()==false)	cl_prop  >>  enableSSL;
		else {
			//	Try to initialize EnableSSL from default device value
			def_prop = ds_class->get_default_device_property(dev_prop[i].name);
			if (def_prop.is_empty()==false)	def_prop  >>  enableSSL;
		}
		//	And try to extract EnableSSL value from database
		if (dev_prop[i].is_empty()==false)	dev_prop[i]  >>  enableSSL;

		//	Try to initialize DatabaseHost from class property
		cl_prop = ds_class->get_class_property(dev_prop[++i].name);
		if (cl_prop.is_empty()==false)	cl_prop  >>  databaseHost;
		else {
			//	Try to initialize DatabaseHost from default device value
			def_prop = ds_class->get_default_device_property(dev_prop[i].name);
			if (def_prop.is_empty()==false)	def_prop  >>  databaseHost;
		}
		//	And try to extract DatabaseHost value from database
		if (dev_prop[i].is_empty()==false)	dev_prop[i]  >>  databaseHost;

		//	Try to initialize DatabasePort from class property
		cl_prop = ds_class->get_class_property(dev_prop[++i].name);
		if (cl_prop.is_empty()==false)	cl_prop  >>  databasePort;
		else {
			//	Try to initialize DatabasePort from default device value
			def_prop = ds_class->get_default_device_property(dev_prop[i].name);
			if (def_prop.is_empty()==false)	def_prop  >>  databasePort;
		}
		//	And try to extract DatabasePort value from database
		if (dev_prop[i].is_empty()==false)	dev_prop[i]  >>  databasePort;

		//	Try to initialize DatabaseUsername from class property
		cl_prop = ds_class->get_class_property(dev_prop[++i].name);
		if (cl_prop.is_empty()==false)	cl_prop  >>  databaseUsername;
		else {
			//	Try to initialize DatabaseUsername from default device value
			def_prop = ds_class->get_default_device_property(dev_prop[i].name);
			if (def_prop.is_empty()==false)	def_prop  >>  databaseUsername;
		}
		//	And try to extract DatabaseUsername value from database
		if (dev_prop[i].is_empty()==false)	dev_prop[i]  >>  databaseUsername;

		//	Try to initialize DatabasePassword from class property
		cl_prop = ds_class->get_class_property(dev_prop[++i].name);
		if (cl_prop.is_empty()==false)	cl_prop  >>  databasePassword;
		else {
			//	Try to initialize DatabasePassword from default device value
			def_prop = ds_class->get_default_device_property(dev_prop[i].name);
			if (def_prop.is_empty()==false)	def_prop  >>  databasePassword;
		}
		//	And try to extract DatabasePassword value from database
		if (dev_prop[i].is_empty()==false)	dev_prop[i]  >>  databasePassword;

		//	Try to initialize DatabaseSchema from class property
		cl_prop = ds_class->get_class_property(dev_prop[++i].name);
		if (cl_prop.is_empty()==false)	cl_prop  >>  databaseSchema;
		else {
			//	Try to initialize DatabaseSchema from default device value
			def_prop = ds_class->get_default_device_property(dev_prop[i].name);
			if (def_prop.is_empty()==false)	def_prop  >>  databaseSchema;
		}
		//	And try to extract DatabaseSchema value from database
		if (dev_prop[i].is_empty()==false)	dev_prop[i]  >>  databaseSchema;

		//	Try to initialize DatabaseTable from class property
		cl_prop = ds_class->get_class_property(dev_prop[++i].name);
		if (cl_prop.is_empty()==false)	cl_prop  >>  databaseTable;
		else {
			//	Try to initialize DatabaseTable from default device value
			def_prop = ds_class->get_default_device_property(dev_prop[i].name);
			if (def_prop.is_empty()==false)	def_prop  >>  databaseTable;
		}
		//	And try to extract DatabaseTable value from database
		if (dev_prop[i].is_empty()==false)	dev_prop[i]  >>  databaseTable;

		//	Try to initialize RefreshTime from class property
		cl_prop = ds_class->get_class_property(dev_prop[++i].name);
		if (cl_prop.is_empty()==false)	cl_prop  >>  refreshTime;
		else {
			//	Try to initialize RefreshTime from default device value
			def_prop = ds_class->get_default_device_property(dev_prop[i].name);
			if (def_prop.is_empty()==false)	def_prop  >>  refreshTime;
		}
		//	And try to extract RefreshTime value from database
		if (dev_prop[i].is_empty()==false)	dev_prop[i]  >>  refreshTime;

		//	Try to initialize Timeout from class property
		cl_prop = ds_class->get_class_property(dev_prop[++i].name);
		if (cl_prop.is_empty()==false)	cl_prop  >>  timeout;
		else {
			//	Try to initialize Timeout from default device value
			def_prop = ds_class->get_default_device_property(dev_prop[i].name);
			if (def_prop.is_empty()==false)	def_prop  >>  timeout;
		}
		//	And try to extract Timeout value from database
		if (dev_prop[i].is_empty()==false)	dev_prop[i]  >>  timeout;

		//	Try to initialize RecoveryTime from class property
		cl_prop = ds_class->get_class_property(dev_prop[++i].name);
		if (cl_prop.is_empty()==false)	cl_prop  >>  recoveryTime;
		else {
			//	Try to initialize RecoveryTime from default device value
			def_prop = ds_class->get_default_device_property(dev_prop[i].name);
			if (def_prop.is_empty()==false)	def_prop  >>  recoveryTime;
		}
		//	And try to extract RecoveryTime value from database
		if (dev_prop[i].is_empty()==false)	dev_prop[i]  >>  recoveryTime;

		//	Try to initialize AutoStart from class property
		cl_prop = ds_class->get_class_property(dev_prop[++i].name);
		if (cl_prop.is_empty()==false)	cl_prop  >>  autoStart;
		else {
			//	Try to initialize AutoStart from default device value
			def_prop = ds_class->get_default_device_property(dev_prop[i].name);
			if (def_prop.is_empty()==false)	def_prop  >>  autoStart;
		}
		//	And try to extract AutoStart value from database
		if (dev_prop[i].is_empty()==false)	dev_prop[i]  >>  autoStart;

		//	Try to initialize AuxDatabaseHost from class property
		cl_prop = ds_class->get_class_property(dev_prop[++i].name);
		if (cl_prop.is_empty()==false)	cl_prop  >>  auxDatabaseHost;
		else {
			//	Try to initialize AuxDatabaseHost from default device value
			def_prop = ds_class->get_default_device_property(dev_prop[i].name);
			if (def_prop.is_empty()==false)	def_prop  >>  auxDatabaseHost;
		}
		//	And try to extract AuxDatabaseHost value from database
		if (dev_prop[i].is_empty()==false)	dev_prop[i]  >>  auxDatabaseHost;

		//	Try to initialize AuxDatabasePort from class property
		cl_prop = ds_class->get_class_property(dev_prop[++i].name);
		if (cl_prop.is_empty()==false)	cl_prop  >>  auxDatabasePort;
		else {
			//	Try to initialize AuxDatabasePort from default device value
			def_prop = ds_class->get_default_device_property(dev_prop[i].name);
			if (def_prop.is_empty()==false)	def_prop  >>  auxDatabasePort;
		}
		//	And try to extract AuxDatabasePort value from database
		if (dev_prop[i].is_empty()==false)	dev_prop[i]  >>  auxDatabasePort;

		//	Try to initialize AuxDatabaseUsername from class property
		cl_prop = ds_class->get_class_property(dev_prop[++i].name);
		if (cl_prop.is_empty()==false)	cl_prop  >>  auxDatabaseUsername;
		else {
			//	Try to initialize AuxDatabaseUsername from default device value
			def_prop = ds_class->get_default_device_property(dev_prop[i].name);
			if (def_prop.is_empty()==false)	def_prop  >>  auxDatabaseUsername;
		}
		//	And try to extract AuxDatabaseUsername value from database
		if (dev_prop[i].is_empty()==false)	dev_prop[i]  >>  auxDatabaseUsername;

		//	Try to initialize AuxDatabasePassword from class property
		cl_prop = ds_class->get_class_property(dev_prop[++i].name);
		if (cl_prop.is_empty()==false)	cl_prop  >>  auxDatabasePassword;
		else {
			//	Try to initialize AuxDatabasePassword from default device value
			def_prop = ds_class->get_default_device_property(dev_prop[i].name);
			if (def_prop.is_empty()==false)	def_prop  >>  auxDatabasePassword;
		}
		//	And try to extract AuxDatabasePassword value from database
		if (dev_prop[i].is_empty()==false)	dev_prop[i]  >>  auxDatabasePassword;

		//	Try to initialize AuxDatabaseSchema from class property
		cl_prop = ds_class->get_class_property(dev_prop[++i].name);
		if (cl_prop.is_empty()==false)	cl_prop  >>  auxDatabaseSchema;
		else {
			//	Try to initialize AuxDatabaseSchema from default device value
			def_prop = ds_class->get_default_device_property(dev_prop[i].name);
			if (def_prop.is_empty()==false)	def_prop  >>  auxDatabaseSchema;
		}
		//	And try to extract AuxDatabaseSchema value from database
		if (dev_prop[i].is_empty()==false)	dev_prop[i]  >>  auxDatabaseSchema;

		//	Try to initialize AuxDatabaseTimestampTable from class property
		cl_prop = ds_class->get_class_property(dev_prop[++i].name);
		if (cl_prop.is_empty()==false)	cl_prop  >>  auxDatabaseTimestampTable;
		else {
			//	Try to initialize AuxDatabaseTimestampTable from default device value
			def_prop = ds_class->get_default_device_property(dev_prop[i].name);
			if (def_prop.is_empty()==false)	def_prop  >>  auxDatabaseTimestampTable;
		}
		//	And try to extract AuxDatabaseTimestampTable value from database
		if (dev_prop[i].is_empty()==false)	dev_prop[i]  >>  auxDatabaseTimestampTable;

		//	Try to initialize AuxDatabaseFailedTable from class property
		cl_prop = ds_class->get_class_property(dev_prop[++i].name);
		if (cl_prop.is_empty()==false)	cl_prop  >>  auxDatabaseFailedTable;
		else {
			//	Try to initialize AuxDatabaseFailedTable from default device value
			def_prop = ds_class->get_default_device_property(dev_prop[i].name);
			if (def_prop.is_empty()==false)	def_prop  >>  auxDatabaseFailedTable;
		}
		//	And try to extract AuxDatabaseFailedTable value from database
		if (dev_prop[i].is_empty()==false)	dev_prop[i]  >>  auxDatabaseFailedTable;

	}

	/*----- PROTECTED REGION ID(DataImporter::get_device_property_after) ENABLED START -----*/

    try
    {
        if(enableSSL)
        {
            if(certificateFile.empty())
                throw(invalid_argument("CertificateFile property is empty or not defined"));

            checkIfFileExists(certificateFile);
        }

        if(storagePath.empty())
            throw(invalid_argument("StoragePath property is empty or not defined"));

        checkIfDirectoryExists(storagePath);

        if(remoteHost.empty())
            throw(invalid_argument("RemoteHost property is empty or not defined"));

        if(remotePort<1 || remotePort>MAX_PORT_NUMBER)
            throw(invalid_argument("RemotePort property out of range or not defined"));

        if(remoteUsername.empty())
            throw(invalid_argument("RemoteUsername property is empty or not defined"));

        if(remotePassword.empty())
            throw(invalid_argument("RemotePassword property is empty or not defined"));

        if(databaseHost.empty())
                throw(invalid_argument("DatabaseHost property is empty or not defined"));

        if(databasePort<1 || databasePort>MAX_PORT_NUMBER)
            throw(invalid_argument("DatabasePort property out of range or not defined"));

        if(databaseUsername.empty())
            throw(invalid_argument("DatabaseUsername property is empty or not defined"));

        if(databasePassword.empty())
            throw(invalid_argument("DatabasePassword property is empty or not defined"));

        if(databaseSchema.empty())
            throw(invalid_argument("DatabaseSchema property is empty or not defined"));

        if(databaseTable.empty())
            throw(invalid_argument("DatabaseTable property is empty or not defined"));

        if(refreshTime<1 || refreshTime>MAX_REFRESH_TIME)
            throw(invalid_argument("RefreshTime property out of range or not defined"));

        if(timeout<1 || timeout>MAX_TIMEOUT)
            throw(invalid_argument("Timeout property out of range or not defined"));

        if(recoveryTime<1 || recoveryTime>MAX_RECOVERY_TIME)
            throw(invalid_argument("RecoveryTime property out of range or not defined"));

        if(auxDatabaseHost.empty())
                throw(invalid_argument("AuxDatabaseHost property is empty or not defined"));

        if(auxDatabasePort<1 || auxDatabasePort>MAX_PORT_NUMBER)
            throw(invalid_argument("AuxDatabasePort property out of range or not defined"));

        if(auxDatabaseUsername.empty())
            throw(invalid_argument("AuxDatabaseUsername property is empty or not defined"));

        if(auxDatabasePassword.empty())
            throw(invalid_argument("AuxDatabasePassword property is empty or not defined"));

        if(auxDatabaseSchema.empty())
            throw(invalid_argument("AuxDatabaseSchema property is empty or not defined"));

        if(auxDatabaseTimestampTable.empty())
            throw(invalid_argument("AuxDatabaseTimestampTable property is empty or not defined"));

        if(auxDatabaseFailedTable.empty())
            throw(invalid_argument("AuxDatabaseFailedTable property is empty or not defined"));

        m_configuration_sp = Configuration::create(certificateFile, storagePath,
            remoteHost, remotePort, remoteUsername, remotePassword, databaseHost,
            databasePort, databaseUsername, databasePassword, databaseSchema,
            databaseTable, refreshTime, timeout, recoveryTime, auxDatabaseHost,
            auxDatabasePort, auxDatabaseUsername, auxDatabasePassword,
            auxDatabaseSchema, auxDatabaseTimestampTable, auxDatabaseFailedTable);
    }
    catch(invalid_argument& ex)
    {
        set_state(Tango::FAULT);
        stringstream error_stream;
        error_stream << "DataImporter::get_device_property() " << ex.what() << endl;
        set_status(error_stream.str());
    }

	/*----- PROTECTED REGION END -----*/	//	DataImporter::get_device_property_after
}

//--------------------------------------------------------
/**
 *	Method      : DataImporter::always_executed_hook()
 *	Description : method always executed before any command is executed
 */
//--------------------------------------------------------
void DataImporter::always_executed_hook()
{
	INFO_STREAM << "DataImporter::always_executed_hook()  " << device_name << endl;
	/*----- PROTECTED REGION ID(DataImporter::always_executed_hook) ENABLED START -----*/

    if(get_state() != Tango::FAULT)
    {
        if(m_client_sp)
        {
            set_state(m_client_sp->readState());

            set_status(m_client_sp->readStatus());
        }
    }

	/*----- PROTECTED REGION END -----*/	//	DataImporter::always_executed_hook
}

//--------------------------------------------------------
/**
 *	Method      : DataImporter::read_attr_hardware()
 *	Description : Hardware acquisition for attributes
 */
//--------------------------------------------------------
void DataImporter::read_attr_hardware(TANGO_UNUSED(vector<long> &attr_list))
{
	DEBUG_STREAM << "DataImporter::read_attr_hardware(vector<long> &attr_list) entering... " << endl;
	/*----- PROTECTED REGION ID(DataImporter::read_attr_hardware) ENABLED START -----*/

	//	Add your own code

	/*----- PROTECTED REGION END -----*/	//	DataImporter::read_attr_hardware
}


//--------------------------------------------------------
/**
 *	Method      : DataImporter::add_dynamic_attributes()
 *	Description : Create the dynamic attributes if any
 *                for specified device.
 */
//--------------------------------------------------------
void DataImporter::add_dynamic_attributes()
{
	/*----- PROTECTED REGION ID(DataImporter::add_dynamic_attributes) ENABLED START -----*/

	//	Add your own code to create and add dynamic attributes if any

	/*----- PROTECTED REGION END -----*/	//	DataImporter::add_dynamic_attributes
}

//--------------------------------------------------------
/**
 *	Command On related method
 *	Description: Activate data importer
 *
 */
//--------------------------------------------------------
void DataImporter::on()
{
	DEBUG_STREAM << "DataImporter::On()  - " << device_name << endl;
	/*----- PROTECTED REGION ID(DataImporter::on) ENABLED START -----*/

    try
    {
        if(m_client_sp)
            m_client_sp->start();
    }
    catch(std::exception& ex)
    {
        set_state(Tango::ALARM);
        std::stringstream error_stream;
        error_stream << "DataImporter::On() " << ex.what() << std::endl;
        set_status(error_stream.str());
    }
    catch(...)
    {
        set_state(Tango::ALARM);
        set_status("DataImporter::On() unknown error");
    }


	/*----- PROTECTED REGION END -----*/	//	DataImporter::on
}
//--------------------------------------------------------
/**
 *	Command Off related method
 *	Description: Deactivate data importer
 *
 */
//--------------------------------------------------------
void DataImporter::off()
{
	DEBUG_STREAM << "DataImporter::Off()  - " << device_name << endl;
	/*----- PROTECTED REGION ID(DataImporter::off) ENABLED START -----*/

    try
    {
        if(m_client_sp)
            m_client_sp->stop();
    }
    catch(std::exception& ex)
    {
        set_state(Tango::ALARM);
        std::stringstream error_stream;
        error_stream << "DataImporter::Off() " << ex.what() << std::endl;
        set_status(error_stream.str());
    }
    catch(...)
    {
        set_state(Tango::ALARM);
        set_status("DataImporter::Off() unknown error");
    }

	/*----- PROTECTED REGION END -----*/	//	DataImporter::off
}

/*----- PROTECTED REGION ID(DataImporter::namespace_ending) ENABLED START -----*/

//==============================================================================
//      DataImporter::checkIfFileExists()
//==============================================================================
void DataImporter::checkIfFileExists(std::string fileName)
    throw(std::invalid_argument)
{
    DEBUG_STREAM << "DataImporter::checkIfFileExists()  - " << device_name << endl;

    boost::filesystem::path path(fileName);

    if(!boost::filesystem::exists(path))
    {
        std::stringstream errorStream;
        errorStream << "File " << fileName
            << " not exists" << std::endl;
        throw std::invalid_argument(errorStream.str());
    }

    INFO_STREAM << "DataImporter::checkIfFileExists() " << fileName << endl;
}

//==============================================================================
//      DataImporter::checkIfDirectoryExists()
//==============================================================================
void DataImporter::checkIfDirectoryExists(std::string directoryName)
    throw(std::invalid_argument)
{
    DEBUG_STREAM << "DataImporter::checkIfFileExists()  - " << device_name << endl;

    boost::filesystem::path path(directoryName);

    if(!boost::filesystem::exists(path))
    {
        std::stringstream errorStream;
        errorStream << "Directory " << directoryName << " not exists" << std::endl;
        throw std::invalid_argument(errorStream.str());
    }

    if(!boost::filesystem::is_directory(path))
    {
        std::stringstream errorStream;
        errorStream << directoryName << " is not a directory" << std::endl;
        throw std::invalid_argument(errorStream.str());
    }

    INFO_STREAM << "DataImporter::checkIfDirectoryExists() " << directoryName << endl;
}

/*----- PROTECTED REGION END -----*/	//	DataImporter::namespace_ending
} //	namespace
