#ifndef SSLCLIENT_H
#define	SSLCLIENT_H

#include <Client.h>

#include <boost/asio/ssl.hpp>

namespace DataImporter_ns
{

class SSLClient : public Client
{
protected:
//------------------------------------------------------------------------------
//  [Protected] Constructor destructor
//------------------------------------------------------------------------------
    SSLClient(Tango::DeviceImpl*, Configuration::SP);

    virtual ~SSLClient();

    class Deleter;
    friend class Deleter;
    class Deleter
    {
        public:
                void operator()(SSLClient* d) { delete d; }
    };

public:
//------------------------------------------------------------------------------
//  [Public] Class creation method
//------------------------------------------------------------------------------
    static Client::SP create(Tango::DeviceImpl*, Configuration::SP);

protected:
//------------------------------------------------------------------------------
//  [Protected] Connection initialization methods
//------------------------------------------------------------------------------
    virtual void startConnect(boost::asio::ip::tcp::resolver::iterator);

    virtual void handleConnect(const boost::system::error_code&,
        boost::asio::ip::tcp::resolver::iterator);

//------------------------------------------------------------------------------
//  [Protected] SSL handshake initialization methods
//------------------------------------------------------------------------------
    virtual void startHandShake();

    virtual void handleHandShake(const boost::system::error_code&);

//------------------------------------------------------------------------------
//  [Protected] Request response methods
//------------------------------------------------------------------------------
    virtual void startWriteRequest();

    virtual void startReadResponseHeader();

    virtual void startReadResponseBody(boost::uint32_t);

    virtual void startReadData(FileWrapper::SP);

//------------------------------------------------------------------------------
//  [Protected] Connection close method
//------------------------------------------------------------------------------
    virtual void closeConnection();

//------------------------------------------------------------------------------
//  [Protected] Class variables
//------------------------------------------------------------------------------
    //SSL connection context
    boost::asio::ssl::context m_sSLContext;

    //SSL connection socket
    boost::asio::ssl::stream<boost::asio::ip::tcp::socket> m_sSLSocket;
};

}   //End of namespace

#endif	/* SSLCLIENT_H */

