#ifndef FILEWRAPPER_H
#define	FILEWRAPPER_H

#include <tango.h>

#include <boost/filesystem.hpp>
#include <boost/shared_ptr.hpp>

namespace DataImporter_ns
{

class FileWrapper : public Tango::LogAdapter
{
public:
//------------------------------------------------------------------------------
//  [Public] Shared pointer typedef
//------------------------------------------------------------------------------
    typedef boost::shared_ptr<FileWrapper> SP;

protected:
//------------------------------------------------------------------------------
//  [Protected] Constructor destructor deleter
//------------------------------------------------------------------------------
    FileWrapper(Tango::DeviceImpl*, std::string, std::string, int, std::string,
        boost::uint64_t) /*throw(std::logic_error)*/;

    virtual ~FileWrapper();

    class Deleter;
    friend class Deleter;
    class Deleter
    {
        public:
            void operator()(FileWrapper* d) { delete d; }
    };

public:
//------------------------------------------------------------------------------
//	[Public] Class creation method
//------------------------------------------------------------------------------
    static FileWrapper::SP create(Tango::DeviceImpl*, std::string, std::string,
        int, std::string, boost::uint64_t) /*throw(std::logic_error)*/;

//------------------------------------------------------------------------------
//	[Public] Properties getter methods
//------------------------------------------------------------------------------
    virtual std::string getStoragePath();

    virtual std::string getFilePath();

    virtual int getFileVersion();

    virtual std::string getFileName();

//------------------------------------------------------------------------------
//	[Public] Input stream methods
//------------------------------------------------------------------------------
    virtual bool isOpen();

    virtual bool isBad();

    virtual bool isCompleted();

    boost::uint64_t getLeftToWrite();

    virtual void write(std::vector<char>&, boost::uint64_t&);

//------------------------------------------------------------------------------
//	[Public] Clean up method
//------------------------------------------------------------------------------
    virtual void cleanUp();

protected:
//------------------------------------------------------------------------------
//  [Protected] Class variables
//------------------------------------------------------------------------------
    //Storage path property
    const std::string m_storagePath;

    //File path property
    const std::string m_filePath;

    //File version property
    const int m_fileVersion;

    //File name property
    const std::string m_fileName;

    //Expected file size
    boost::uint64_t m_expectedFileSize;

    //Output file path
    boost::filesystem::path m_outputFilePath;

    //Output file stream
    std::ofstream m_outputFileStream;
};

}   //End of namespace

#endif	/* FILEWRAPPER_H */
