package it.inaf.ia2.gms.service;

import it.inaf.ia2.gms.model.GroupBreadcrumb;
import it.inaf.ia2.gms.model.GroupNode;
import it.inaf.ia2.gms.model.GroupsModelRequest;
import it.inaf.ia2.gms.model.GroupsModelResponse;
import it.inaf.ia2.gms.model.PaginatedData;
import it.inaf.ia2.gms.persistence.model.Group;
import it.inaf.ia2.gms.persistence.model.User;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GroupsModelService {

    @Autowired
    private UsersService usersService;

    @Autowired
    private GroupsService groupsService;

    public GroupsModelResponse getGroupsModel(GroupsModelRequest request, String userId) {

        User user = usersService.getUserById(userId);
        Group group = groupsService.getGroupById(request.getGroupId());

        GroupsModelResponse response = new GroupsModelResponse();

        response.setPage("groups");

        List<GroupNode> groupNodes = groupsService.getSubgroups(group, user);

        response.setGroupsPanel(new PaginatedData<>(groupNodes, request.getPaginatorPage(), request.getPaginatorPageSize()));

        response.setPermissions(groupsService.getPermissions(group, user));
        response.setBreadcrumbs(buildBreadcrumbs(new ArrayList<>(), group));

        return response;
    }

    private List<GroupBreadcrumb> buildBreadcrumbs(List<GroupBreadcrumb> breadcrumbs, Group group) {

        GroupBreadcrumb bc = new GroupBreadcrumb();
        bc.setGroupId(group.getId());
        bc.setGroupName(group.getName());
        breadcrumbs.add(bc);

        if (group.getParentGroup() == null) {
            return breadcrumbs;
        } else {
            return buildBreadcrumbs(breadcrumbs, group.getParentGroup());
        }
    }
}
