package it.inaf.ia2.gms.persistence;

import it.inaf.ia2.gms.DataSourceConfig;
import it.inaf.ia2.gms.model.Permission;
import it.inaf.ia2.gms.persistence.model.PermissionEntity;
import it.inaf.ia2.gms.persistence.model.GroupEntity;
import java.util.List;
import javax.sql.DataSource;
import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(SpringRunner.class)
@ContextConfiguration(classes = DataSourceConfig.class)
public class PermissionsDAOTest {

    @Autowired
    private DataSource dataSource;

    private GroupsDAO groupsDAO;
    private PermissionsDAO permissionsDAO;

    @Before
    public void setUp() {
        groupsDAO = new GroupsDAO(dataSource);
        permissionsDAO = new PermissionsDAO(dataSource);
    }

    @Test
    public void testAll() {

        GroupEntity root = new GroupEntity();
        root.setId("ROOT");
        root.setName("ROOT");
        root.setPath("");
        groupsDAO.createGroup(root);

        String userId = "user_id";

        PermissionEntity permission = new PermissionEntity();
        permission.setGroupId(root.getId());
        permission.setUserId(userId);
        permission.setPermission(Permission.ADMIN);
        permission.setGroupPath(root.getPath());

        permissionsDAO.createPermission(permission);

        List<PermissionEntity> permissions = permissionsDAO.findUserPermissions(userId);

        assertEquals(1, permissions.size());
        assertEquals(Permission.ADMIN, permissions.get(0).getPermission());
        assertEquals(userId, permissions.get(0).getUserId());

        permissions = permissionsDAO.findUserPermissions(userId, root.getPath());
        assertEquals(1, permissions.size());

        permissions = permissionsDAO.getGroupsPermissions(root.getId());
        assertEquals(1, permissions.size());

        permissionsDAO.deletePermission(permission.getGroupId(), permission.getUserId(), permission.getPermission());

        permissions = permissionsDAO.findUserPermissions(userId);
        assertTrue(permissions.isEmpty());
    }
}
