package it.inaf.ia2.gms.controller;

import it.inaf.ia2.gms.persistence.model.GroupEntity;
import it.inaf.ia2.gms.service.GroupsService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/ws")
public class WebServiceController {

    @Autowired
    private GroupsService groupsService;

    /**
     * Creates a group and its ancestors if they are missing. It doesn't fail if
     * the last group already exists.
     */
    @PostMapping("/group")
    public ResponseEntity<GroupEntity> createGroup(@RequestBody List<String> names) {

        GroupEntity group = groupsService.getRoot();

        for (String name : names) {
            Optional<GroupEntity> optGroup = groupsService.findGroupByParentAndName(group, name);
            if (optGroup.isPresent()) {
                group = optGroup.get();
            } else {
                group = groupsService.addGroup(group, name);
            }
        }

        return new ResponseEntity<>(group, HttpStatus.CREATED);
    }

    public void deleteGroup() {

    }

    public void addMember() {

    }

    public void removeMember() {

    }

    public void addPrivilege() {

    }

    public void deletePrivilege() {

    }

    public void prepareToJoin() {

    }
}
