package it.inaf.ia2.gms.service;

import it.inaf.ia2.gms.model.Permission;
import it.inaf.ia2.gms.model.RapUser;
import it.inaf.ia2.gms.model.UserPermission;
import it.inaf.ia2.gms.persistence.model.PermissionEntity;
import it.inaf.ia2.gms.persistence.PermissionsDAO;
import it.inaf.ia2.gms.persistence.model.GroupEntity;
import it.inaf.ia2.gms.rap.RapClient;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PermissionsService {

    private final PermissionsDAO permissionsDAO;
    private final RapClient rapClient;

    @Autowired
    public PermissionsService(PermissionsDAO permissionsDAO, RapClient rapClient) {
        this.permissionsDAO = permissionsDAO;
        this.rapClient = rapClient;
    }

    public List<UserPermission> getUserPermissions(GroupEntity group) {

        List<PermissionEntity> permissions = permissionsDAO.getGroupsPermissions(group.getId());

        Set<String> userIdentifiers = permissions.stream()
                .map(p -> p.getUserId())
                .collect(Collectors.toSet());

        Map<String, RapUser> users = rapClient.getUsers(userIdentifiers).stream()
                .collect(Collectors.toMap(RapUser::getId, Function.identity()));

        List<UserPermission> result = new ArrayList<>();

        for (PermissionEntity p : permissions) {
            RapUser rapUser = users.get(p.getUserId());
            if (rapUser != null) {
                UserPermission permission = new UserPermission();
                permission.setPermission(p.getPermission());
                permission.setUser(rapUser);
                result.add(permission);
            }
        }

        return result;
    }

    public Permission getGroupPermission(GroupEntity group, String userId) {
        List<PermissionEntity> permissions = permissionsDAO.findUserPermissions(userId, group.getPath());
        return PermissionUtils.getGroupPermission(group, permissions).orElse(null);
    }

    public void deletePermission(String userId, String groupId, Permission permission) {
        permissionsDAO.deletePermission(userId, groupId, permission);
    }
}
