package it.inaf.ia2.gms.controller;

import it.inaf.ia2.gms.authn.SessionData;
import it.inaf.ia2.gms.model.Permission;
import it.inaf.ia2.gms.model.request.GroupsRequest;
import it.inaf.ia2.gms.model.response.GroupsTabResponse;
import it.inaf.ia2.gms.persistence.model.GroupEntity;
import it.inaf.ia2.gms.service.GroupsService;
import it.inaf.ia2.gms.service.GroupsTreeBuilder;
import it.inaf.ia2.gms.service.PermissionsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GroupsTabResponseBuilder {

    @Autowired
    private SessionData session;

    @Autowired
    private PermissionsService permissionsService;

    @Autowired
    private GroupsService groupsService;

    @Autowired
    private GroupsTreeBuilder groupsTreeBuilder;

    public GroupsTabResponse getGroupsTab(GroupsRequest request) {

        GroupEntity group = groupsService.getGroupById(request.getGroupId());

        GroupsTabResponse response = new GroupsTabResponse();

        response.setBreadcrumbs(groupsService.getBreadcrumbs(group.getPath()));

        Permission currentNodePermissions = permissionsService.getUserPermissionForGroup(group, session.getUserId());
        response.setPermission(currentNodePermissions);

        response.setGroupsPanel(groupsTreeBuilder.listSubGroups(group, request, session.getUserId()));

        return response;
    }
}
