/* Vuex store, for centralized state management */

import Vue from 'vue';
import Vuex from 'vuex';

Vue.use(Vuex);

export default new Vuex.Store({
  state: {
    // values populated from API calls
    model: {
      breadcrumbs: [],
      groupsPanel: null,
      permissionsPanel: null,
      membersPanel: null,
      permission: null,
      user: null
    },
    // values used to perform API calls
    input: {
      selectedGroupId: 'ROOT',
      paginatorPageSize: 20,
      paginatorPage: 1,
      selectedTab: 'groups',
      tabIndex: 0,
      searchFilter: null
    },
    loading: false
  },
  mutations: {
    updateHomePageModel(state, model) {
      this.state.model.breadcrumbs = model.breadcrumbs;
      this.state.model.groupsPanel = model.groupsPanel;
      this.state.model.permission = model.permission;
      this.state.model.user = model.user;
    },
    updateGroups(state, model) {
      this.state.model.breadcrumbs = model.breadcrumbs;
      this.state.model.groupsPanel = model.groupsPanel;
      this.state.model.permission = model.permission;
    },
    updateGroupsPanel(state, groupsPanel) {
      this.state.model.groupsPanel = groupsPanel;
    },
    updatePermissionsPanel(state, permissionsPanel) {
      this.state.model.permissionsPanel = permissionsPanel;
    },
    updateMembersPanel(state, membersPanel) {
      this.state.model.membersPanel = membersPanel;
    },
    setTabIndex(state, tabIndex) {
      // this will trigger the tabChanged() method in Main.vue
      this.state.input.tabIndex = tabIndex;
    },
    setLoading(state, loading) {
      this.state.loading = loading;
    }
  },
  getters: {
    selectedGroupId: state => {
      return state.model.breadcrumbs[state.model.breadcrumbs.length - 1].groupId;
    }
  }
});
