package it.inaf.ia2.gms;

import java.util.Collection;
import java.util.Map;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;

public class CustomAuthenticationData extends UsernamePasswordAuthenticationToken {

    private final Map<String, Object> attributes;

    public CustomAuthenticationData(String username, Map<String, Object> attributes, Collection<? extends GrantedAuthority> authorities) {
        super(username, "N/A", authorities);
        this.attributes = attributes;
    }

    public Map<String, Object> getAttributes() {
        return attributes;
    }
}
