package it.inaf.ia2.gms;

import java.util.List;
import java.util.Map;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.provider.token.DefaultUserAuthenticationConverter;
import org.springframework.security.oauth2.provider.token.store.jwk.JwkTokenStore;

public class CustomIdTokenConverter extends DefaultUserAuthenticationConverter {

    private final JwkTokenStore jwkTokenStore;

    public CustomIdTokenConverter(String keySetUri) {
        this.jwkTokenStore = new JwkTokenStore(keySetUri);
    }

    @Override
    public Authentication extractAuthentication(Map<String, ?> map) {

        String idToken = (String) map.get("id_token");

        OAuth2AccessToken token = jwkTokenStore.readAccessToken(idToken);

        Map<String, Object> claims = token.getAdditionalInformation();
        //OAuth2RefreshToken refreshToken = token.getRefreshToken();

        String principal = (String) claims.get("sub");

        List<GrantedAuthority> authorities = AuthorityUtils.createAuthorityList("ROLE_USER");

        return new CustomAuthenticationData(principal, claims, authorities);
    }
}
