package it.inaf.ia2.gms.controller;

import it.inaf.ia2.gms.manager.InvitedRegistrationManager;
import it.inaf.ia2.gms.persistence.model.InvitedRegistration;
import it.inaf.ia2.gms.service.GroupNameService;
import java.io.IOException;
import java.io.InputStream;
import java.util.Scanner;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

@Controller
public class InvitedRegistrationController {

    @Autowired
    private InvitedRegistrationManager invitedRegistrationManager;

    @Autowired
    private GroupNameService groupNameService;

    @GetMapping(value = "/invited-registration", produces = MediaType.TEXT_HTML_VALUE)
    public void index(@RequestParam("token") String token, HttpServletRequest request, HttpServletResponse response) throws IOException {
        InvitedRegistration invitedRegistration = invitedRegistrationManager.getInvitedRegistrationFromToken(token);

        String html = getFileContent("invited-registration.html")
                .replace("#EMAIL#", invitedRegistration.getEmail())
                .replace("#GROUPS#", getGroupsList(invitedRegistration))
                .replace("#HOME#", request.getContextPath());

        response.getOutputStream().print(html);
    }

    @GetMapping(value = "/registration-completed", produces = MediaType.TEXT_HTML_VALUE)
    public void completed(HttpServletRequest request, HttpServletResponse response) throws IOException {

        response.setContentType("text/html;charset=UTF-8");

        InvitedRegistration invitedRegistration = (InvitedRegistration) request.getAttribute("invited-registration");
        if (invitedRegistration == null) {
            // redirect to home
            String baseUrl = ServletUriComponentsBuilder.fromCurrentContextPath().build().toUriString();
            response.sendRedirect(baseUrl);
        } else {
            String html = getFileContent("registration-completed.html")
                    .replace("#GROUPS#", getGroupsList(invitedRegistration))
                    .replace("#HOME#", request.getContextPath());

            response.getOutputStream().print(html);
        }
    }

    @DeleteMapping(value = "/registration", produces = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<?> deleteInvitedRegistration(@RequestParam("request_id") String requestId, @RequestParam("group_id") String groupId) {
        invitedRegistrationManager.deleteInvitedRegistration(requestId, groupId);
        return ResponseEntity.noContent().build();
    }

    private String getFileContent(String templateFileName) throws IOException {
        try (InputStream in = InvitedRegistrationController.class.getClassLoader().getResourceAsStream("templates/" + templateFileName)) {
            Scanner s = new Scanner(in).useDelimiter("\\A");
            return s.hasNext() ? s.next() : "";
        }
    }

    private String getGroupsList(InvitedRegistration invitedRegistration) {
        String groups = "<ul>";
        for (String groupName : groupNameService.getGroupsNamesFromIdentifiers(
                invitedRegistration.getGroupsPermissions().keySet())) {
            groups += "<li>" + groupName + "</li>";
        }
        groups += "</ul>";
        return groups;
    }
}
