package it.inaf.ia2.gms.model;

import it.inaf.ia2.gms.model.response.PaginatedData;
import java.util.ArrayList;
import java.util.List;
import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;
import org.junit.Test;

public class PaginatedDataTest {

    @Test
    public void testPagination() {

        List<Integer> allItems = new ArrayList<>();
        for (int i = 1; i <= 30; i++) {
            allItems.add(i);
        }

        PaginatedData<Integer> paginatedData = new PaginatedData<>(allItems, 2, 10);

        assertEquals(10, paginatedData.getItems().size());
        assertEquals(11, (int) paginatedData.getItems().get(0));
        assertEquals(20, (int) paginatedData.getItems().get(9));
        assertEquals(30, paginatedData.getTotalItems());
        assertEquals(3, paginatedData.getTotalPages());
        assertFalse(paginatedData.isHasPreviousPages());
        assertFalse(paginatedData.isHasFollowingPages());
        assertEquals(10, paginatedData.getPageSize());
        assertEquals(3, paginatedData.getLinks().size());
        assertEquals(1, (int) paginatedData.getLinks().get(0));
        assertEquals(2, (int) paginatedData.getLinks().get(1));
        assertEquals(3, (int) paginatedData.getLinks().get(2));
    }

    @Test
    public void testLotOfPages() {

        List<Integer> allItems = new ArrayList<>();
        for (int i = 1; i <= 200; i++) {
            allItems.add(i);
        }

        PaginatedData<Integer> paginatedData = new PaginatedData<>(allItems, 8, 10);

        assertEquals(10, paginatedData.getItems().size());
        assertEquals(71, (int) paginatedData.getItems().get(0));
        assertEquals(80, (int) paginatedData.getItems().get(9));
        assertEquals(200, paginatedData.getTotalItems());
        assertEquals(20, paginatedData.getTotalPages());
        assertTrue(paginatedData.isHasPreviousPages());
        assertTrue(paginatedData.isHasFollowingPages());
        assertEquals(10, paginatedData.getPageSize());
        assertEquals(5, paginatedData.getLinks().size());
        assertEquals(6, (int) paginatedData.getLinks().get(0));
        assertEquals(10, (int) paginatedData.getLinks().get(4));
    }

    /**
     * When the page size change (from a smaller size to a bigger size) and we
     * are in the last page it could be that we need to set a lower page number
     * because the selected page is empty.
     */
    @Test
    public void testGoToLastPageIfPageOverflow() {

        List<Integer> allItems = new ArrayList<>();
        for (int i = 1; i <= 6; i++) {
            allItems.add(i);
        }

        PaginatedData<Integer> paginatedData = new PaginatedData<>(allItems, 2, 20);

        assertEquals(1, paginatedData.getCurrentPage()); // back to last page
        assertEquals(6, paginatedData.getItems().size());
        assertEquals(6, paginatedData.getTotalItems());
    }

    @Test(expected = IllegalArgumentException.class)
    public void testIllegalPageNumber() {
        new PaginatedData<>(new ArrayList<>(), 0, 20);
    }

    @Test
    public void testPageOneForEmptyList() {
        PaginatedData<Integer> paginatedData = new PaginatedData<>(new ArrayList<>(), 1, 20);
        assertEquals(1, paginatedData.getCurrentPage());
    }
}
