package it.inaf.ia2.gms.controller;

import it.inaf.ia2.gms.authn.SessionData;
import it.inaf.ia2.gms.model.GroupsModelRequest;
import it.inaf.ia2.gms.model.GroupsModelResponse;
import it.inaf.ia2.gms.service.GroupsModelBuilder;
import static org.junit.Assert.assertEquals;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import static org.mockito.ArgumentMatchers.any;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;
import org.mockito.junit.MockitoJUnitRunner;
import org.springframework.test.web.servlet.MockMvc;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.get;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;

@RunWith(MockitoJUnitRunner.class)
public class GroupsControllerTest {

    @Mock
    private SessionData session;

    @Mock
    private GroupsModelBuilder groupsModelService;

    @InjectMocks
    private GroupsController controller;

    private MockMvc mockMvc;

    @Before
    public void init() {
        mockMvc = MockMvcBuilders.standaloneSetup(controller).build();
    }

    @Test
    public void testGetGroups() throws Exception {

        GroupsModelResponse response = new GroupsModelResponse();

        when(groupsModelService.getGroupsModel(any(), any()))
                .thenReturn(response);

        mockMvc.perform(get("/groups?groupId=ROOT&tab=groups&paginatorPageSize=20&paginatorPage=1&page=main"))
                .andExpect(status().isOk());

        ArgumentCaptor<GroupsModelRequest> requestCaptor = ArgumentCaptor.forClass(GroupsModelRequest.class);
        verify(groupsModelService).getGroupsModel(requestCaptor.capture(), any());
        GroupsModelRequest request = requestCaptor.getValue();

        assertEquals("ROOT", request.getGroupId());
        assertEquals("groups", request.getTab());
        assertEquals(1, request.getPaginatorPage());
        assertEquals(20, request.getPaginatorPageSize());
    }
}
