package it.inaf.ia2.gms.controller;

import it.inaf.ia2.gms.model.Permission;
import it.inaf.ia2.gms.model.response.GroupsTabResponse;
import it.inaf.ia2.gms.model.response.PaginatedData;
import java.util.ArrayList;
import static org.hamcrest.CoreMatchers.is;
import static org.hamcrest.CoreMatchers.notNullValue;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import static org.mockito.ArgumentMatchers.any;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import static org.mockito.Mockito.when;
import org.mockito.junit.MockitoJUnitRunner;
import org.springframework.test.web.servlet.MockMvc;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.get;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.jsonPath;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;

@RunWith(MockitoJUnitRunner.class)
public class GroupsControllerTest {

    @Mock
    private GroupsTabResponseBuilder groupsTabResponseBuilder;

    @InjectMocks
    private GroupsController controller;

    private MockMvc mockMvc;

    @Before
    public void init() {
        mockMvc = MockMvcBuilders.standaloneSetup(controller).build();
    }

    @Test
    public void testGetGroups() throws Exception {

        GroupsTabResponse response = new GroupsTabResponse();
        response.setBreadcrumbs(new ArrayList<>());
        response.setGroupsPanel(new PaginatedData<>(new ArrayList<>(), 1, 10));
        response.setPermission(Permission.ADMIN);

        when(groupsTabResponseBuilder.getGroupsTab(any())).thenReturn(response);

        mockMvc.perform(get("/groups?groupId=ROOT&paginatorPageSize=20&paginatorPage=1"))
                .andExpect(status().isOk())
                .andExpect(jsonPath("$.breadcrumbs", notNullValue()))
                .andExpect(jsonPath("$.groupsPanel", notNullValue()))
                .andExpect(jsonPath("$.permission", is("ADMIN")));
    }
}
