package it.inaf.ia2.gms.service;

import it.inaf.ia2.gms.model.GroupsModelRequest;
import it.inaf.ia2.gms.model.GroupsModelResponse;
import it.inaf.ia2.gms.model.PaginatedData;
import it.inaf.ia2.gms.model.Permission;
import it.inaf.ia2.gms.model.RapUser;
import it.inaf.ia2.gms.model.UserPermission;
import it.inaf.ia2.gms.persistence.model.GroupEntity;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GroupsModelBuilder {

    @Autowired
    private GroupsService groupsService;

    @Autowired
    private GroupsTreeBuilder groupsTreeBuilder;

    @Autowired
    private MembersService membersService;

    @Autowired
    private PermissionsService permissionsService;

    public GroupsModelResponse getGroupsModel(GroupsModelRequest request, String userId) {

        GroupEntity group = groupsService.getGroupById(request.getGroupId());

        GroupsModelResponse response = new GroupsModelResponse();

        response.setPage("groups");

        response.setBreadcrumbs(groupsService.getBreadcrumbs(group.getPath()));

        Permission currentNodePermissions = permissionsService.getGroupPermission(group, userId);
        response.setPermission(currentNodePermissions);

        switch (request.getTab()) {
            case "groups":
                response.setGroupsPanel(groupsTreeBuilder.listSubGroups(group.getId(), userId, request));
                break;
            case "members":
                if (currentNodePermissions != Permission.TRAVERSE) {
                    List<RapUser> members = membersService.getMembers(group.getId());
                    response.setMembersPanel(new PaginatedData<>(members, request.getPaginatorPage(), request.getPaginatorPageSize()));
                }
                break;
            case "permissions":
                if (currentNodePermissions == Permission.ADMIN) {
                    List<UserPermission> permissions = permissionsService.getUserPermissions(group);
                    response.setPermissionsPanel(new PaginatedData<>(permissions, request.getPaginatorPage(), request.getPaginatorPageSize()));
                }
                break;
        }

        return response;
    }
}
