/*
 * This file is part of gms
 * Copyright (C) 2021 Istituto Nazionale di Astrofisica
 * SPDX-License-Identifier: GPL-3.0-or-later
 */
package it.inaf.ia2.gms.controller;

import it.inaf.ia2.aa.ServiceLocator;
import it.inaf.ia2.aa.UserManager;
import it.inaf.ia2.gms.authn.SessionData;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class KeepAliveController {

    private static final Logger LOG = LoggerFactory.getLogger(KeepAliveController.class);

    @Autowired
    private SessionData sessionData;

    private final UserManager userManager;

    public KeepAliveController() {
        userManager = ServiceLocator.getInstance().getUserManager();
    }

    @GetMapping(value = "/ui/keepAlive", produces = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<?> keepAlive(HttpServletRequest request) {
        LOG.trace("Keepalive called");
        if (sessionData.getExpiresIn() < 60) {
            sessionData.setUser(userManager.refreshToken(request));
            LOG.trace("RAP token refreshed");
        }
        // empty JSON object response
        return ResponseEntity.ok(new HashMap<>());
    }
}
