/*
 * This file is part of gms
 * Copyright (C) 2021 Istituto Nazionale di Astrofisica
 * SPDX-License-Identifier: GPL-3.0-or-later
 */
package it.inaf.ia2.gms.exception;

import it.inaf.ia2.gms.persistence.LoggingDAO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@RestControllerAdvice
public class LoggingExceptionHandler extends ResponseEntityExceptionHandler {

    @Autowired
    private LoggingDAO loggingDAO;

    @ExceptionHandler(Exception.class)
    public ResponseEntity<Object> exception(Exception ex) throws Exception {
        loggingDAO.logException(ex);
        throw ex;
    }
}
