/*
 * This file is part of gms
 * Copyright (C) 2021 Istituto Nazionale di Astrofisica
 * SPDX-License-Identifier: GPL-3.0-or-later
 */
package it.inaf.ia2.gms.model.request;

import javax.validation.constraints.Min;

public class PaginatedModelRequest {

    @Min(1)
    private int paginatorPage;
    private int paginatorPageSize;

    public PaginatedModelRequest() {
        this.paginatorPage = 1;
        this.paginatorPageSize = 20;
    }

    public int getPaginatorPage() {
        return paginatorPage;
    }

    public void setPaginatorPage(int paginatorPage) {
        this.paginatorPage = paginatorPage;
    }

    public int getPaginatorPageSize() {
        return paginatorPageSize;
    }

    public void setPaginatorPageSize(int paginatorPageSize) {
        this.paginatorPageSize = paginatorPageSize;
    }
}
