/*
 * This file is part of gms
 * Copyright (C) 2021 Istituto Nazionale di Astrofisica
 * SPDX-License-Identifier: GPL-3.0-or-later
 */
package it.inaf.ia2.gms.service;

import it.inaf.ia2.gms.model.Permission;
import it.inaf.ia2.gms.persistence.model.GroupEntity;
import it.inaf.ia2.gms.persistence.model.PermissionEntity;
import java.util.Collections;
import java.util.List;
import static org.junit.Assert.assertEquals;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(JUnit4.class)
public class PermissionUtilsTest {

    @Test
    public void testDirectPermission() {

        GroupEntity group = new GroupEntity();
        group.setId("id");
        group.setName("name");
        group.setPath("path");

        PermissionEntity permission = new PermissionEntity();
        permission.setGroupId("id");
        permission.setGroupPath("path");
        permission.setPermission(Permission.MANAGE_MEMBERS);

        List<PermissionEntity> permissions = Collections.singletonList(permission);

        assertEquals(Permission.MANAGE_MEMBERS, PermissionUtils.getGroupPermission(group, permissions).get());
    }

    @Test
    public void testPermissionInheritedFromParent() {

        GroupEntity group = new GroupEntity();
        group.setId("id_LBT_INAF");
        group.setName("INAF");
        group.setPath("LBT:INAF");

        PermissionEntity permission = new PermissionEntity();
        permission.setGroupId("id_LBT");
        permission.setGroupPath("LBT");
        permission.setPermission(Permission.ADMIN);

        List<PermissionEntity> permissions = Collections.singletonList(permission);

        assertEquals(Permission.ADMIN, PermissionUtils.getGroupPermission(group, permissions).get());
    }

    @Test
    public void testTraversalIfPermissionInChild() {

        GroupEntity group = new GroupEntity();
        group.setId("id_LBT");
        group.setName("name");
        group.setPath("LBT");

        PermissionEntity permission = new PermissionEntity();
        permission.setGroupId("id_LBT_INAF_P1");
        permission.setGroupPath("LBT:INAF:P1");
        permission.setPermission(Permission.VIEW_MEMBERS);

        List<PermissionEntity> permissions = Collections.singletonList(permission);

        assertEquals(Permission.TRAVERSE, PermissionUtils.getGroupPermission(group, permissions).get());
    }
}
