package it.inaf.ia2.gms.authn;

import java.security.Principal;
import java.util.Map;

public class RapPrincipal implements Principal {

    private final String token;
    private final String sub;
    private final String altSub;

    public RapPrincipal(String token, Map<String, Object> jwtClaims) {
        this.token = token;
        sub = (String) jwtClaims.get("sub");
        altSub = (String) jwtClaims.get("alt_sub");
    }

    @Override
    public String getName() {
        return sub;
    }

    /**
     * Alternative subject identifier: used during a join.
     */
    public String getAlternativeName() {
        return altSub;
    }

    public String getToken() {
        return token;
    }
}
