package it.inaf.ia2.gms.persistence.model;

import it.inaf.ia2.gms.service.model.Permission;
import java.io.Serializable;
import java.util.Objects;

public class UserGroupId implements Serializable {

    String _user;
    String _group;
    Permission permission;

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 71 * hash + Objects.hashCode(this._user);
        hash = 71 * hash + Objects.hashCode(this._group);
        hash = 71 * hash + Objects.hashCode(this.permission);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final UserGroupId other = (UserGroupId) obj;
        if (!Objects.equals(this._user, other._user)) {
            return false;
        }
        if (!Objects.equals(this._group, other._group)) {
            return false;
        }
        if (this.permission != other.permission) {
            return false;
        }
        return true;
    }
}
