package it.inaf.ia2.gms.persistence;

import it.inaf.ia2.gms.persistence.model.Group;
import it.inaf.ia2.gms.persistence.model.User;
import java.util.Arrays;
import static org.junit.Assert.assertEquals;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.jdbc.AutoConfigureTestDatabase;
import org.springframework.boot.test.autoconfigure.orm.jpa.DataJpaTest;
import org.springframework.test.context.junit4.SpringRunner;

@DataJpaTest
@AutoConfigureTestDatabase
@RunWith(SpringRunner.class)
public class GroupsRepositoryTest {

    @Autowired
    private UsersRepository usersRepository;

    @Autowired
    private GroupsRepository groupsRepository;

    @Test
    public void testCreateGroup() {

        User user1 = new User();
        user1.setId("user1");
        user1 = usersRepository.save(user1);
        User user2 = new User();
        user2.setId("user2");
        user2 = usersRepository.save(user2);

        Group group = new Group();
        group.setId("parent-group");
        group.setName("Parent");

        // Test cascade persist
        Group childGroup = new Group();
        childGroup.setId("child-group");
        childGroup.setName("Child 1");

        group.setGroupsMembers(Arrays.asList(childGroup));

        group = groupsRepository.save(group);

        // Test cascade merge
        Group childGroup2 = new Group();
        childGroup2.setId("child-group-2");
        childGroup2.setName("Child 2");
        group.getGroupsMembers().add(childGroup2);
        groupsRepository.save(group);

        // Reload
        group = groupsRepository.findById("parent-group").get();

        assertEquals("Parent", group.getName());
        assertEquals(2, group.getGroupsMembers().size());
        assertEquals("Child 1", group.getGroupsMembers().get(0).getName());
        assertEquals("Child 2", group.getGroupsMembers().get(1).getName());
    }
}
