package it.inaf.ia2.gms.persistence;

import it.inaf.ia2.gms.persistence.model.Group;
import it.inaf.ia2.gms.persistence.model.User;
import it.inaf.ia2.gms.persistence.model.UserGroup;
import it.inaf.ia2.gms.service.GroupsService;
import it.inaf.ia2.gms.service.model.GroupNode;
import it.inaf.ia2.gms.service.model.Permission;
import java.util.List;
import static org.junit.Assert.assertEquals;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.jdbc.AutoConfigureTestDatabase;
import org.springframework.boot.test.autoconfigure.orm.jpa.DataJpaTest;
import org.springframework.test.context.junit4.SpringRunner;

@DataJpaTest
@AutoConfigureTestDatabase
@RunWith(SpringRunner.class)
public class NestedGroupsIntegrationTest {

    @Autowired
    private UsersRepository usersRepository;

    @Autowired
    private GroupsRepository groupsRepository;

    @Autowired
    private PermissionsRepository permissionsRepository;

    @Test
    public void testNestedGroupRetrieval() {

        GroupsService groupsService = new GroupsService(groupsRepository, usersRepository, permissionsRepository);

        // Create user
        User user = new User();
        user.setId("user");
        user = usersRepository.save(user);

        // Setup groups
        Group lbt = groupsService.addGroup(GroupsService.ROOT, "LBT");
        Group lbtInaf = groupsService.addGroup(lbt.getId(), "INAF");
        Group lbtInafProgram = groupsService.addGroup(lbtInaf.getId(), "P1");

        // Setup permissions
        UserGroup permission = new UserGroup();
        permission.setUser(user);
        permission.setGroup(lbtInafProgram);
        permission.setPermission(Permission.MANAGE_MEMBERS);
        permissionsRepository.save(permission);

        List<GroupNode> groupNodes = groupsService.getSubgroups(GroupsService.ROOT, user.getId());
        assertEquals(1, groupNodes.size());
    }

}
