package it.inaf.ia2.gms.controller;

import it.inaf.ia2.gms.authn.SessionData;
import it.inaf.ia2.gms.model.GroupNode;
import it.inaf.ia2.gms.model.Permission;
import it.inaf.ia2.gms.model.response.PaginatedData;
import it.inaf.ia2.gms.persistence.model.GroupEntity;
import it.inaf.ia2.gms.service.GroupsService;
import it.inaf.ia2.gms.service.GroupsTreeBuilder;
import it.inaf.ia2.gms.service.PermissionsService;
import java.util.ArrayList;
import static org.hamcrest.CoreMatchers.is;
import static org.hamcrest.CoreMatchers.notNullValue;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import static org.mockito.ArgumentMatchers.any;
import static org.mockito.ArgumentMatchers.eq;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import static org.mockito.Mockito.when;
import org.mockito.Spy;
import org.mockito.junit.MockitoJUnitRunner;
import org.springframework.test.web.servlet.MockMvc;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.get;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.jsonPath;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;

@RunWith(MockitoJUnitRunner.class)
public class GroupsControllerTest {

    @Mock
    private SessionData session;

    @Mock
    private GroupsService groupsService;

    @Mock
    private PermissionsService permissionsService;

    @Mock
    private GroupsTreeBuilder groupsTreeBuilder;

    @Spy
    @InjectMocks
    private GroupsTabResponseBuilder groupsTabResponseBuilder;

    @InjectMocks
    private GroupsController controller;

    private MockMvc mockMvc;

    @Before
    public void init() {
        mockMvc = MockMvcBuilders.standaloneSetup(controller).build();
    }

    @Test
    public void testGetGroups() throws Exception {

        when(session.getUserId()).thenReturn("admin_id");

        GroupEntity root = new GroupEntity();
        root.setId("ROOT");
        root.setName("ROOT");
        root.setPath("");

        when(groupsService.getGroupById(eq("ROOT"))).thenReturn(root);

        when(permissionsService.getUserPermissionForGroup(eq(root), eq("admin_id")))
                .thenReturn(Permission.ADMIN);

        PaginatedData<GroupNode> groupsPanel = new PaginatedData<>(new ArrayList<>(), 1, 10);
        when(groupsTreeBuilder.listSubGroups(eq("ROOT"), eq("admin_id"), any())).thenReturn(groupsPanel);

        mockMvc.perform(get("/groups?groupId=ROOT&paginatorPageSize=20&paginatorPage=1"))
                .andExpect(status().isOk())
                .andExpect(jsonPath("$.breadcrumbs", notNullValue()))
                .andExpect(jsonPath("$.groupsPanel", notNullValue()))
                .andExpect(jsonPath("$.permission", is("ADMIN")));
    }
}
