const BASE_API_URL = "http://localhost:8081/"

function apiRequest(url, data) {
  return new Promise((resolve, reject) => {
    fetch(url, data)
      .then(response => {
        if([200, 201, 204, 400].includes(response.status)) { // valid status codes
          resolve(response.json());
        } else {
          response.json().then(jsonValue => dispatchApiErrorEvent(jsonValue));
        }
      })
      .catch(error => {
        dispatchApiErrorEvent(error);
      });
  });
}

function dispatchApiErrorEvent(error) {
  let message;
  if(error.message) {
    message = error.message;
  } else {
    message = 'Generic error';
  }

  let event = new CustomEvent('apiError');
  event.message = message;
  document.dispatchEvent(event);
}

export default {
  fetchGroupsModel (input) {
    let url = BASE_API_URL
            + 'groups?groupId=' + input.selectedGroupId
            + '&tab=' + input.selectedTab
            + '&paginatorPageSize=' + input.paginatorPageSize
            + '&paginatorPage=' + input.paginatorPage
            + '&page=' + input.page;
    return apiRequest(url, {
      method: 'GET',
      cache: 'no-cache',
      credentials: 'include',
      headers: {
        'Content-Type': 'application/json',
        'Accept': 'application/json',
      }
    });
  },
  addGroup (newGroupName, input) {
    let url = BASE_API_URL + 'group';
    return apiRequest(url, {
      method: 'POST',
      cache: 'no-cache',
      credentials: 'include',
      headers: {
        'Content-Type': 'application/json',
        'Accept': 'application/json',
      },
      body: JSON.stringify({
        newGroupName: newGroupName,
        parentGroupId: input.selectedGroupId,
        paginatorPageSize: input.paginatorPageSize,
        paginatorPage: input.paginatorPage
      })
    });
  },
  renameGroup (groupId, newGroupName, input) {
    let url = BASE_API_URL + 'group/' + groupId;
    return apiRequest(url, {
      method: 'PUT',
      cache: 'no-cache',
      credentials: 'include',
      headers: {
        'Content-Type': 'application/json',
        'Accept': 'application/json',
      },
      body: JSON.stringify({
        newGroupName: newGroupName,
        paginatorPageSize: input.paginatorPageSize,
        paginatorPage: input.paginatorPage
      })
    });
  },
  deleteGroup (groupId, input) {
    let url = BASE_API_URL + 'group/' + groupId
            + '?paginatorPageSize=' + input.paginatorPageSize
            + '&paginatorPage=' + input.paginatorPage;
    return apiRequest(url, {
      method: 'DELETE',
      cache: 'no-cache',
      credentials: 'include',
      headers: {
        'Content-Type': 'application/json',
        'Accept': 'application/json',
      }
    });
  }
};
