/* Vuex store, for centralized state management */

import Vue from 'vue';
import Vuex from 'vuex';
import client from 'api-client';

Vue.use(Vuex);

export default new Vuex.Store({
  state: {
    // values populated from API calls
    model: null,
    // values used to perform API calls
    input: {
      selectedGroupId: 'ROOT',
      paginatorPageSize: 20,
      paginatorPage: 1,
      selectedTab: 'groups',
      page: 'main'
    }
  },
  mutations: {
    fetchGroupsModel(state) {
      client.fetchGroupsModel(this.state.input)
        .then(model => {
          this.state.model = model;
        });
    },
    updateGroupsPanel(state, groupsPanel) {
      this.state.model.groupsPanel = groupsPanel;
    }
  },
  getters: {
    selectedGroupId: state => {
      return state.model.breadcrumbs[state.model.breadcrumbs.length - 1].groupId;
    }
  }
});
